% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_automap_coords.R
\name{stat_automap_coords}
\alias{stat_automap_coords}
\title{Attach coordinates with 'cartographer'}
\usage{
stat_automap_coords(
  mapping = NULL,
  data = NULL,
  geom = "sf_inset",
  position = "identity",
  ...,
  feature_type = NA,
  na.rm = TRUE,
  inset = NA,
  fun.geometry = NULL,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{inset}{Inset configuration; see \code{\link[ggmapinset:configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[ggmapinset:coord_sf_inset]{coord_sf_inset()}}).}

\item{fun.geometry}{A function that takes a \code{sfc} object and returns a \code{sfc_POINT} with the
same length as the input. If \code{NULL}, \code{function(x) sf::st_point_on_surface(sf::st_zm(x))}
will be used. Note that the function may warn about the incorrectness of
the result if the data is not projected, but you can ignore this except
when you really care about the exact locations.}
}
\value{
A plot layer
}
\description{
Use \code{\link{cartographer}} to attach a spatial column to the data based
on place names in another column. The spatial data is then reduced to
coordinates in the same way as \code{\link[ggplot2:stat_sf_coordinates]{stat_sf_coordinates()}}.
}
\section{Computed variables}{

\describe{
\item{geometry}{\code{sf} geometry column representing the points}
\item{x}{X dimension of the simple feature}
\item{y}{Y dimension of the simple feature}
\item{x_inset}{X dimension of the simple feature after inset transformation}
\item{y_inset}{Y dimension of the simple feature after inset transformation}
\item{inside_inset}{logical indicating points inside the inset viewport}
\item{inset_scale}{1 for points outside the inset, otherwise the configured inset scale parameter}
}
}

\examples{
library(ggplot2)

events <- data.frame(
  county = c("Mecklenburg", "Carteret", "Moore", "Caldwell"),
  proportion_A = c(0.1, 0.8, 0.0, 0.6)
)

ggplot(events, aes(location = county)) +
  geom_sf(aes(fill = proportion_A), stat = "automap") +
  geom_label(aes(label = county), stat = "automap_coords") +
  coord_automap(feature_type = "sf.nc")
}
\seealso{
\code{\link[ggmapinset:stat_sf_coordinates_inset]{ggmapinset::stat_sf_coordinates_inset()}}
}
