% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-layers.R
\name{transition_layers}
\alias{transition_layers}
\title{Build up a plot, layer by layer}
\usage{
transition_layers(layer_length = 1, transition_length = 1,
  keep_layers = TRUE, from_blank = TRUE, layer_order = NULL,
  layer_names = NULL)
}
\arguments{
\item{layer_length}{The proportional time to pause at each layer before a new
one enters}

\item{transition_length}{The proportional time to use for the entrance of a
new layer}

\item{keep_layers}{Either an integer indicating for how many following layers
the layers should stay on screen or a logical. In the case of the later,
\code{TRUE} will mean keep the layer for the remainder of the animation
(equivalent to setting it to \code{Inf}) and \code{FALSE} will mean to transition the
layer out as the next layer enters.}

\item{from_blank}{Should the first layer transition in or be present on the
onset of the animation}

\item{layer_order}{An alternative order the layers should appear in (default
to using the stacking order). All other arguments that references the layers
index in some way refers to this order.}

\item{layer_names}{A character vector of names for each layers, to be used
when interpreting label literals}
}
\description{
This transition gradually adds layers to the plot in the order they have been
defined. By default prior layers are kept for the remainder of the animation,
but they can also be set to be removed as the next layer enters.
}
\section{Label variables}{

\code{transition_layers} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{transitioning} is a boolean indicating whether the frame is part of the
transitioning phase
\item \strong{previous_layer} The name of the last layer the animation was showing
\item \strong{closest_layer} The name of the layer the animation is closest to showing
\item \strong{next_layer} The name of the next layer the animation will show
\item \strong{nlayers} The total number of layers
}
}

\section{Object permanence}{

\code{transition_layer} does not link rows across data to the same graphic
element, so elements will be defined uniquely by each row and the enter and
exit of the layer it belongs to.
}

\examples{
# Default is to use layer order and keep layers for duration of animation
anim <- ggplot(mtcars, aes(mpg, disp)) +
  geom_point() +
  geom_smooth(colour = 'grey', se = FALSE) +
  geom_smooth(aes(colour = factor(gear))) +
  transition_layers(layer_length = 1, transition_length = 2) +
  enter_fade() + enter_grow()

# Start with the first layer already present
anim1 <- ggplot(mtcars, aes(mpg, disp)) +
  geom_point() +
  geom_smooth(colour = 'grey', se = FALSE) +
  geom_smooth(aes(colour = factor(gear))) +
  transition_layers(layer_length = 1, transition_length = 2,
                    from_blank = FALSE) +
  enter_fade() + enter_grow()

# Change the order of the layers
anim2 <- ggplot(mtcars, aes(mpg, disp)) +
  geom_point() +
  geom_smooth(colour = 'grey', se = FALSE) +
  geom_smooth(aes(colour = factor(gear))) +
  transition_layers(layer_length = 1, transition_length = 2,
                    from_blank = FALSE, layer_order = c(3, 1, 2)) +
  enter_fade() + enter_grow()

# Keep layer 1 for the whole animation, but remove the 2nd layer as the 3rd
# enters
anim3 <- ggplot(mtcars, aes(mpg, disp)) +
  geom_point() +
  geom_smooth(colour = 'grey', se = FALSE) +
  geom_smooth(aes(colour = factor(gear))) +
  transition_layers(layer_length = 1, transition_length = 2,
                    from_blank = FALSE, keep_layers = c(Inf, 0, 0)) +
  enter_fade() + enter_grow() +
  exit_fade() + exit_shrink()

}
\seealso{
Other transitions: \code{\link{transition_components}},
  \code{\link{transition_events}},
  \code{\link{transition_filter}},
  \code{\link{transition_manual}},
  \code{\link{transition_null}},
  \code{\link{transition_reveal}},
  \code{\link{transition_states}},
  \code{\link{transition_time}}
}
\concept{transitions}
