% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-group.R
\name{align_group}
\alias{align_group}
\title{Group and align observations based on a group vector}
\usage{
align_group(group, active = NULL)
}
\arguments{
\item{group}{A character define the groups of the observations.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Splits observations into groups, with slice ordering based on group levels.
}
\examples{
set.seed(1L)
small_mat <- matrix(rnorm(81), nrow = 9)
ggheatmap(small_mat) +
    anno_top() +
    align_group(sample(letters[1:4], ncol(small_mat), replace = TRUE))
}
