% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-quad-.R
\name{quad_layout}
\alias{quad_layout}
\title{Arrange Plots in the Quad-Side of a main plot}
\usage{
quad_layout(
  data = NULL,
  align = NULL,
  mapping = aes(),
  ...,
  theme = NULL,
  active = NULL,
  width = NA,
  height = NA
)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from parent layout. The conversion of data depends on the
\code{align} argument and will use, \code{\link[=fortify_data_frame]{fortify_data_frame()}}
or \code{\link[=fortify_matrix]{fortify_matrix()}}:
\itemize{
\item If \code{align} is \code{NULL}, a data frame is required. When inherited by the
annotation stack, no transposition will be applied.
\item If \code{align} is a string, a matrix is required. When inherited by the column
annotation stack, it will be transposed.
}}

\item{align}{A string indicating the alignment direction:
\itemize{
\item \code{"horizontal"}: Align plots horizontally.
\item \code{"vertical"}: Align plots vertically.
\item \code{"both"}: Align plots in both directions.
}

By default, the function does not align observations.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}} or
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function integrates the functionalities of \code{quad_free()},
\code{quad_alignh()}, \code{quad_alignv()}, and \code{quad_alignb()} into a single
interface.
}
