% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-wrap.R
\name{wrap}
\alias{wrap}
\title{Wrap Arbitrary Graphics for Alignment}
\usage{
wrap(plot, ..., align = "panel", on_top = TRUE, clip = TRUE, vp = NULL)
}
\arguments{
\item{plot}{Any graphic that can be converted into a \link[grid:grid.grob]{grob} using
\code{\link[=patch]{patch()}}.}

\item{...}{Additional arguments passed to the \code{\link[=patch]{patch()}} method.}

\item{align}{A string specifying the area to place the plot: \code{"full"} for the
full area, \code{"plot"} for the full plotting area (including the axis label), or
\code{"panel"} for only the actual area where data is drawn.}

\item{on_top}{A single boolean value indicates whether the graphic plot
should be put frontmost. Note: the graphic plot will always put above the
background.}

\item{clip}{A single boolean value indicating whether the grob should be
clipped if they expand outside their designated area.}

\item{vp}{A \link[grid:viewport]{viewport} object, you can use this to define the
plot area.}
}
\value{
A \code{wrapped_plot} object that can be directly placed into
\code{\link[=align_plots]{align_plots()}}.
}
\description{
The \code{wrap()} function allows non-ggplot2 elements to be converted into a
compliant representation for use with \code{\link[=align_plots]{align_plots()}}. This is useful for
adding any graphics that can be converted into a \link[grid:grid.grob]{grob} with the
\code{\link[=patch]{patch()}} method.
}
\seealso{
\itemize{
\item \link{patch.grob}
\item \link{patch.ggplot}
\item \link{patch.formula}
\item \link{patch.Heatmap}
\item \link{patch.HeatmapList}
\item \link{patch.HeatmapAnnotation}
}
}
