% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scatter_ridges_function.R
\name{ggScatRidges}
\alias{ggScatRidges}
\title{Scatter Plot Combine with Ridgelines}
\usage{
ggScatRidges(
  x,
  y = NULL,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  xlim = NULL,
  ylim = NULL,
  group = NULL,
  color = "lancet",
  ridges = TRUE,
  size = 15,
  draw = TRUE
)
}
\arguments{
\item{x}{As input data. If a dataframe was provided, the dataframe should contain no less than three columns. If no dataframe was supplied, a x vector should be set as an input. The vector should #' contain numerical values.}

\item{y}{As input data. If no dataframe was provided, a y vector should be set as an input along with a x vector. The vector should contain numerical values.}

\item{xlab}{To give a title for the xlab can be given here.}

\item{ylab}{To give a title for the ylab can be given here.}

\item{title}{To give a title for the plot can be given here.}

\item{xlim}{To set scale limits on the xaxis.}

\item{ylim}{To set scale limits on the yaxis.}

\item{group}{The user should provide here the grouping of the rows if a dataframe was provided, otherwise a vector.}

\item{color}{The user can choose from `ggpubr::get_palette`. Default = "lancet".}

\item{ridges}{The user can choose to plot, or not, the ridgelines. Default = TRUE.}

\item{size}{The overall size of the text in the plot. Default = 15.}

\item{draw}{If the user wants to directly draw the plot. Default = TRUE.}
}
\value{
A ggplot object if draw set to 'TRUE' otherwise a grob table is returned but set to invisible.
}
\description{
`ggScatRidges` is a simple function combining a scatter plot generated in 'ggplot2' to a ridgeline plot from 'ggridges' to visualise the disparities of the data points. This helps visualising the distribution of different groups in the data.
}
\examples{
# The following example is based on the iris dataset:

## Example 1
ggScatRidges(x = iris$Sepal.Length, y = iris$Sepal.Width, group= iris$Species,
             color = "lancet", ridges = TRUE, title = "plot iris",
             xlab = "Sepal.Length", ylab = "Sepal.Width", size = 15, draw = TRUE)

## Example 2
iris2 <- iris[,c(1,2,5)] ## The 1st column will be used as 'x', 2nd as 'y', and the 3rd as 'group'.
ggScatRidges(x = iris2, 
             color = "lancet", ridges = TRUE, title = "plot iris",
             xlab = "Sepal.Length", ylab = "Sepal.Width", size = 15, draw = TRUE) 

}
