% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_variable}
\alias{plot.gg_variable}
\title{Plot a \code{\link{gg_variable}} object,}
\usage{
\method{plot}{gg_variable}(x, x_var, time, time_labels, oob = TRUE,
  smooth = TRUE, span, ...)
}
\arguments{
\item{x}{\code{\link{gg_variable}} object created from a \code{randomForestSRC::rfsrc} object}

\item{x_var}{variable (or list of variables) of interest.}

\item{time}{For survival, one or more times of interest}

\item{time_labels}{string labels for times}

\item{oob}{oob estimates (boolean)}

\item{smooth}{type of smooth curve}

\item{span}{tuning parameter for loess smooths}

\item{...}{arguments passed to the \code{\link{gg_variable}} function.}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_variable}} object,
}
\examples{
\dontrun{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris
#iris.obj <- rfsrc(Species ~., data = iris)
data(iris_rf, package="ggRandomForests")

## !! TODO... finish classification variable dependence
# ggrf <- gg_variable(iris_rf, which.outcome=1)


## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality
#airq.obj <- rfsrc(Ozone ~ ., data = airquality)
data(airq_rf, package="ggRandomForests")
ggrf <- gg_variable(airq_rf)
plot(ggrf, x_var="Wind")
plot(ggrf, x_var="Temp")
plot(ggrf, x_var="Solar.R")

## motor trend cars
#mtcars.obj <- rfsrc(mpg ~ ., data = mtcars)
data(mtcars_rf, package="ggRandomForests")
ggrf <- gg_variable(mtcars_rf)

# mtcars$cyl is an ordinal variable
plot(ggrf, x_var="cyl")

# Others are continuous
plot(ggrf, x_var="disp")
plot(ggrf, x_var="hp")
plot(ggrf, x_var="wt")

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------

## survival
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
data(veteran_rf, package="ggRandomForests")

# get the 1 year survival time.
ggrf <- gg_variable(veteran_rf, time=30)

# Generate variable dependance plots for age and diagtime
plot(ggrf, x_var = "age")
plot(ggrf, x_var = "diagtime")

# If we want to compare survival at different time points, say 30, 90 day
# and 1 year
ggrf <- gg_variable(veteran_rf, time=c(30, 90, 365))

# Generate variable dependance plots for age and diagtime
plot(ggrf, x_var = "age")
plot(ggrf, x_var = "diagtime")

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R, Rnews,
7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, Regression
and Classification (RF-SRC), R package version 1.4.
}

