% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_specific_utils.R
\name{optimise_axis_ordering_from_matrix}
\alias{optimise_axis_ordering_from_matrix}
\title{Optimise the Ordering of Axes Using Distance Matrix}
\usage{
optimise_axis_ordering_from_matrix(
  mx,
  method = c("auto", "brute_force", "repetitive_nn_with_2opt"),
  return_detailed = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mx}{A matrix or \code{dist} object describing pairwise distances between axes.}

\item{method}{A character string specifying the method. Can be \code{"auto"},
\code{"brute_force"}, or \code{"repetitive_nn_with_2opt"}.}

\item{return_detailed}{Logical; if \code{TRUE}, returns a list with detailed
results for debugging.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.}
}
\value{
If \code{return_detailed = FALSE}, returns a character vector of axis
names in the chosen order. Otherwise, returns a list with additional data.
}
\description{
Finds an ordering of axes that minimises a pairwise distance metric (usually
the number of crossings). Offers brute-force and heuristic approaches.
}
\keyword{internal}
