% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_specific_utils.R
\name{count_all_edge_crossings}
\alias{count_all_edge_crossings}
\title{Count Edge Crossings for All Numeric Column Pairs}
\usage{
count_all_edge_crossings(
  data,
  approximate = FALSE,
  subsample_prop = 0.4,
  recalibrate = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble} containing the dataset. Only numeric
columns are considered for edge crossing calculations.}

\item{approximate}{estimate crossings based on a subsample of the data. See \code{subsample_prop} for details.}

\item{subsample_prop}{only used when approximate = TRUE.
If 0-1, controls the proportion of data to be sampled to speed up computation.
If a whole number other than 0 or 1, represents the number of rows subsampled}

\item{recalibrate}{when approximating crossings via subsetting,
should number of crossings calculated for the subsample be upscaled to match the full count.
(turned off by default since it amplifies sampling error).}
}
\value{
A \code{data.frame} with three columns:
\describe{
\item{col1}{The name of the first column in the pair.}
\item{col2}{The name of the second column in the pair.}
\item{crossings}{Total number of edge crossings for that pair.}
}
}
\description{
Computes the total number of edge crossings between all pairs of numeric
columns in a given dataset.
}
\details{
The function:
\enumerate{
\item Filters the input data to retain only numeric columns.
\item Computes all possible pairs of numeric columns.
\item Uses \code{count_edge_crossings()} to calculate crossings for each pair.
\item Returns the results in a summarized data frame.
}
}
\keyword{internal}
