% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-girder.R
\docType{data}
\name{girder_experiment}
\alias{girder_experiment}
\title{Girder experiment}
\format{
A tibble with 36 rows and 3 variables
\describe{
\item{girders}{A factor denoting one of the nine girders}
\item{method}{A factor denoting one of the four methods for predicting the shear strength for steel plate girders: Aarau, Karlsruhe,Lehigh, Cardiff}
\item{response}{The shear strength for steel plate girders}
}
}
\source{
Wu, CF Jeff, and Michael S. Hamada. Experiments: planning, analysis, and optimization. John Wiley & Sons, 2011
}
\usage{
girder_experiment
}
\description{
An experiment (Narayanan and Adorisio, 1983) to compare four methods for predicting the shear strength for steel plate girders.
Data for nine girders in the form of the ratio of predicted to observed load for these procedures are given.
Each of the four methods was used to predict the strength of each of the nine girders.
}
\examples{
lm(response ~ method + girders, data = girder_experiment) |>
anova()
}
\keyword{datasets}
