% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias_matrix.R
\name{alias_matrix}
\alias{alias_matrix}
\title{Color Map on Correlations}
\usage{
alias_matrix(
  design,
  midpoint = 0.5,
  digits = 3,
  color_palette = "viridis",
  alpha = 1,
  direction = 1,
  showplot = TRUE
)
}
\arguments{
\item{design}{Design of experiment (Without response)}

\item{midpoint}{A midpoint value between (0,1) to split the color scheme of three colors}

\item{digits}{number of digits to round correlation values. Default is 3}

\item{color_palette}{A character string indicating the color map option to use. Eight options are available: "viridis","cividis","magma","inferno","plasma","rocket","mako","turbo"}

\item{alpha}{The alpha transparency, a number in [0,1]}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors are ordered from darkest to lightest. If -1, the order of colors is reversed}

\item{showplot}{logical indicating to show the correlation plot. If false, the correlation/alias matrix is returned. Default is TRUE}
}
\value{
correlation matrix between main effects and interaction effects from the model.matrix. Alias matrix is also returned
}
\description{
Color Map on Correlations
}
\examples{
alias_matrix(design=aliased_design)
alias_matrix(design=aliased_design, color_palette = "plasma")
alias_matrix(design=aliased_design, color_palette = "magma", direction = -1)
}
