% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise_single_sequence.R
\name{convert_sequences_to_annotations}
\alias{convert_sequences_to_annotations}
\title{Convert a vector of sequences to a dataframe for plotting sequence contents and index annotations (\code{\link[=visualise_single_sequence]{visualise_single_sequence()}} helper)}
\usage{
convert_sequences_to_annotations(
  sequences,
  line_length,
  interval = 15,
  annotations_above = TRUE,
  annotation_vertical_position = 1/3
)
}
\arguments{
\item{sequences}{\verb{character vector}. Sequence to be plotted, split into lines and optionally including blank spacer lines. Output of \code{\link[=convert_input_seq_to_sequence_list]{convert_input_seq_to_sequence_list()}}.}

\item{line_length}{\code{integer}. How long each line should be.}

\item{interval}{\code{integer}. How frequently bases should be annotated with their index. Defaults to \code{15}.}

\item{annotations_above}{\code{logical}. Whether annotations should go above (\code{TRUE}, default) or below (\code{FALSE}) each line of sequence.}

\item{annotation_vertical_position}{\code{numeric}. How far annotation numbers should be rendered above (if \code{index_annotations_above = TRUE}) or below (if \code{index_annotations_above = FALSE}) each base. Defaults to \code{1/3}. Not recommended to change at all. Strongly discouraged to set below 0 or above 1.}
}
\value{
\code{dataframe} Dataframe of coordinates and labels (e.g. \code{"A"} or \verb{"15}), readable by geom_text.
}
\description{
Takes the sequence list output from \code{\link[=convert_input_seq_to_sequence_list]{convert_input_seq_to_sequence_list()}} and creates a dataframe
specifying x and y coordinates and the character to plot at each coordinate. This applies to both
the sequence itself (e.g. determining where on the plot to place an \code{"A"}) and the periodicit
annotations of index number (e.g. determining where on the plot to annotate base number \code{15}).
}
\examples{
convert_sequences_to_annotations(
    c("GGCGGC", "", "ATCG", ""),
    line_length = 6,
    interval = 3,
    annotations_above = TRUE,
    annotation_vertical_position = 1/3
)

convert_sequences_to_annotations(
    c("GGCGGC", "", "ATCG", ""),
    line_length = 6,
    interval = 0
)

}
