% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_metric.R
\name{summarise_metric}
\alias{summarise_metric}
\title{Summarise a TB Metric - A Quick Look Summary}
\usage{
summarise_metric(
  df = NULL,
  metric = NULL,
  countries = NULL,
  conf = c("_lo", "_hi"),
  download_data = TRUE,
  save = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{metric}{Character string specifying the metric to plot}

\item{countries}{A character string specifying the countries to target.}

\item{conf}{Character vector specifying the name variations to use to specify the upper
and lower confidence intervals. Defaults to c("_lo", "_hi"), if set to \code{NULL}
then no confidence intervals are shown.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{verbose}{Logical, defaults to \code{FALSE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional arguments to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A tibble containing the name of the target country, the year of the most recent data available, the most recent
value for the metric, the regional rank, the global rank and the average change in the previous decade.
}
\description{
This function provides a curated list of summary measures for a given TB metric in countries of interest.
It can been used to facilitate reporting and is used extensively in the TB report included in the package
(see \code{\link[getTBinR]{render_country_report}}). It outputs the most recent year of data in the target country for
a given metric, along with the year this data was recorded, the regional and global rank and the average change
in the last decade. For a more customisable metric summary see \code{\link[getTBinR]{summarise_tb_burden}} as a starting point.
}
\examples{

## Get a summary of TB incidence rates for the united kingdom and germany
summarise_metric(metric = "e_inc_100k", countries = c("United Kingdom", "Germany"))

## Get a summary of case detection rates in France
summarise_metric(metric = "c_cdr", countries = "France")

## Get a summary of case detection rates in France - without confidence intervals
summarise_metric(metric = "c_cdr", countries = "France", conf = NULL)

## Provide a dataset and get summary measures from it.
tb <- get_tb_burden()
summarise_metric(df = tb, metric = "c_cdr", countries = "France")
}
