% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_CRU_stack.R
\name{get_CRU_stack}
\alias{get_CRU_stack}
\alias{get_cru_stack}
\title{Download and create a list of terra rast objects of CRU CL v. 2.0 climatology elements}
\source{
\describe{
\item{pre}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_pre.dat.gz}}
\item{rd0}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_rd0.dat.gz}}
\item{tmp}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_tmp.dat.gz}}
\item{dtr}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_dtr.dat.gz}}
\item{reh}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_reh.dat.gz}}
\item{sunp}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_sunp.dat.gz}}
\item{frs}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_frs.dat.gz}}
\item{wnd}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_wnd.dat.gz}, areas originally including Antarctica are removed.}
\item{elv}{\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/grid_10min_elv.dat.gz}, values are converted from kilometres to metres.}
}
This package crops all spatial outputs to an extent of ymin = -60, ymax = 85,
xmin = -180, xmax = 180.
}
\usage{
get_CRU_stack(
  pre = FALSE,
  pre_cv = FALSE,
  rd0 = FALSE,
  tmp = FALSE,
  dtr = FALSE,
  reh = FALSE,
  tmn = FALSE,
  tmx = FALSE,
  sunp = FALSE,
  frs = FALSE,
  wnd = FALSE,
  elv = FALSE,
  cache = FALSE
)

get_cru_stack(
  pre = FALSE,
  pre_cv = FALSE,
  rd0 = FALSE,
  tmp = FALSE,
  dtr = FALSE,
  reh = FALSE,
  tmn = FALSE,
  tmx = FALSE,
  sunp = FALSE,
  frs = FALSE,
  wnd = FALSE,
  elv = FALSE,
  cache = FALSE
)
}
\arguments{
\item{pre}{Fetches precipitation (millimetres/month) from server and
returns it in the data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{pre_cv}{Fetch cv of precipitation (percent) from server and
returns it in the data frame, \code{TRUE}.  Defaults to \code{FALSE}.  NOTE Setting
this to \code{TRUE} will always results in \strong{pre} being set to \code{TRUE} and
returned as well.}

\item{rd0}{Fetches wet-days (number days with >0.1 millimetres rain
per month) and returns it in the data frame?  Defaults to \code{FALSE}.}

\item{tmp}{Fetches temperature (degrees Celsius) and returns it in the
data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{dtr}{Fetches mean diurnal temperature range (degrees Celsius)
and returns it in the data frame?  Defaults to \code{FALSE}.}

\item{reh}{Fetches relative humidity and returns it in the data frame,
\code{TRUE}. Defaults to FALSE.}

\item{tmn}{Calculates minimum temperature values (degrees Celsius)
and returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{tmx}{Calculates maximum temperature (degrees Celsius) and
returns it in the data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{sunp}{Fetch sunshine, percent of maximum possible (percent of
day length) and return it in the data frame?  Defaults to \code{FALSE}.}

\item{frs}{Fetches ground-frost records (number of days with ground-
frost per month) and return it in the data frame?  Defaults to \code{FALSE}.}

\item{wnd}{Fetches 10m wind speed (metres/second) and returns it in the
data frame, \code{TRUE}. Defaults to \code{FALSE}.}

\item{elv}{Fetches elevation (converted to metres) and returns it in
the data frame, \code{TRUE}.  Defaults to \code{FALSE}.}

\item{cache}{Stores CRU CL v. 2.0 data files locally for later use.
If \code{FALSE}, the downloaded files are removed when the \R session is closed.
To take advantage of cached files in future sessions, use \code{cache = TRUE}
even after the initial download and caching.  Defaults to \code{FALSE}.}
}
\value{
A \link[base:list]{base::list} of \link[terra:rast]{terra::rast} objects of \acronym{CRU}
\acronym{CL} v. 2.0 climatology elements.
}
\description{
This function automates downloading and importing CRU CL v. 2.0
climatology data into \R and creates a list of \CRANpkg{terra}
\link[terra:rast]{terra::rast} objects of the data.  If requested, minimum and maximum
temperature may also be automatically calculated as described in the data
\href{https://crudata.uea.ac.uk/cru/data/hrg/tmc/readme.txt}{readme.txt} file.
Data may be cached for later use by this function, saving time downloading
files in future using this function.
}
\section{Nomenclature and Units}{

\describe{
\item{pre}{precipitation (millimetres/month)}
\describe{
\item{cv}{cv of precipitation (percent)}
}
\item{rd0}{wet-days (number days with >0.1 millimetres rain per month)}
\item{tmp}{mean temperature (degrees Celsius)}
\item{dtr}{mean diurnal temperature range (degrees Celsius)}
\item{reh}{relative humidity (percent)}
\item{sunp}{sunshine (percent of maximum possible (percent of day length))}
\item{frs}{ground-frost (number of days with ground-frost per month)}
\item{wnd}{10 metre windspeed (metres/second)}
\item{elv}{elevation (automatically converted to metres)}
}
For more information see the description of the data provided by
\acronym{CRU}, \url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/readme.txt}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Download data and create a list of {terra} `rast` objects of precipitation
# and temperature without caching the data files
CRU_pre_tmp <- get_CRU_stack(pre = TRUE, tmp = TRUE)

CRU_pre_tmp
\dontshow{\}) # examplesIf}
}
\references{
New, Mark, et al. "A high-resolution data set of surface climate
over global land areas." Climate research 21.1 (2002): 1-25.
\url{https://crudata.uea.ac.uk/cru/data/hrg/tmc/new_et_al_10minute_climate_CR.pdf}
}
\seealso{
\link{create_CRU_stack}, \link{manage_cache}.
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
