% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{InstantR}
\alias{InstantR}
\title{InstantR RCurve constructor function}
\usage{
InstantR(Nactive, Ncontrol)
}
\arguments{
\item{Nactive}{Number of patients recruited in the active arm.}

\item{Ncontrol}{Number of patients recruited in the control arm.}
}
\description{
This creates a RCurve object for an instant recruitment distribution.\cr
RCurve objects contain all necessary information to describe a recruitment distribution. They are a particular type of Curve object containing additional recruitment-related information, including patient numbers and the randomisation ratio.\cr
}
\details{
This RCurve is used when either all patients enter at the same time, or a fixed-length follow-up design is used. Note that a PDF function is not provided for this RCurve type, but is not required for standard calculations.
}
\examples{
InstantR(Nactive=100,Ncontrol=100)
}
\author{
James Bell
}
