% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{simulate_trials}
\alias{simulate_trials}
\title{Perform simulations of time-to-event data using arbitrary event, censoring and recruitment distributions.}
\usage{
simulate_trials(active_ecurve, control_ecurve, active_dcurve = Blank(),
  control_dcurve = Blank(), rcurve, assess = NULL, fix_events = NULL,
  iterations, seed, detailed_output = FALSE, output_type = c("matrix",
  "list"))
}
\arguments{
\item{active_ecurve}{Event distribution for the active arm, specified as a Curve object}

\item{control_ecurve}{Event distribution for the control arm, specified as a Curve object}

\item{active_dcurve}{Dropout/censoring distribution for the active arm, specified as a Curve object. By default, a Blank() object, i.e. no dropout.}

\item{control_dcurve}{Dropout/censoring distribution for the control arm, specified as a Curve object. By default, a Blank() object, i.e. no dropout.}

\item{rcurve}{Recruitment distribution, specified as an RCurve object}

\item{assess}{Positive number for the assessment time at which administrative censoring will be performed.}

\item{fix_events}{Positive integer for the number of events to fix (if required), letting the assessment time vary. Alternatively, NULL for fixed time assessment with variable event numbers. Notes: Fixing event numbers overrides any specified assessment time and slows simulation considerably. Default = NULL (fixed analysis time)}

\item{iterations}{Number of simulations to perform. Depending on trial size, 10,000-20,000 is typically OK to analyse on 8GB RAM.}

\item{seed}{Seed number to use. Numerical, although if "Rand" is specified, a system-time-derived number will be used.}

\item{detailed_output}{Boolean to require full details of timings of competing processes. If FALSE, the simplified data only includes the *'ed output columns - this approximately halves RAM requirements. Default=FALSE (simplified).}

\item{output_type}{"matrix" or "list" specifying the type of output required. "matrix" requests a single matrix with a column "iter" to denote the simulation, while "list" creates a list with one entry per simulation. Default="matrix".}
}
\value{
Returns a table with one row per patient per simulation. Table contains the following columns:
\itemize{
 \item{"Time"}{ Simulated actually observed (patient) time of event or censoring: This is the main column of interest for analysis*}
 \item{"Censored"}{ Simulated censoring indicator: 1 denotes censoring (administrative or dropout), 0 denotes an event*}
 \item{"Trt"}{ Treatment group number - 1 is active, 2 is control*}
 \item{"Iter"}{ Simulation number*}
 \item{"ETime"}{ Simulated actual event (patient) time (may or may not be observed)}
 \item{"CTime"}{ Simulated actual censoring/dropout (patient) time (may or may not be observed)}
 \item{"Rec_Time"}{ Simulated (trial) time of recruitment}
 \item{"Assess"}{ Prespecified (trial) time of assessment}
 \item{"RCTime"}{ Simulated actual administrative censoring (patient) time (may or may not be observed)}
}
}
\description{
Function for simulating generalised two-arm time-to-event trial data for NPH trials with arbitrary event, censoring and recruitment distributions.\cr
Event and censoring distributions specified via Curve objects. Recruitment specified via an RCurve object.
As it uses same architecture and similar syntax to nph_curve_trajectories, results ought to be directly comparable.\cr
Can be used to validate outputs from nph_curve_trajectories.\cr
Data sets from this are set up to be automatically analysed with the analyse_sim function.\cr
}
\examples{
example_sim <- simulate_trials(active_ecurve=Weibull(250,0.8),control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100), assess=20, iterations=5,seed=12345)
}
\author{
James Bell
}
