#' Function to prepare metadata of the main dissertations for automatic insertion into scientific articles
#'
#' The dissert_bib function prepares the metadata of the main dissertations to be automatically included in a scientific article. The dissert_bib function internally calls two support functions. The output of the dissert_bib function is the file with the .bib extension, containing the list of dissertation references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
#'
#' @param input_date is a dataframe with the scientific production database in the form of a dissertation
#' @param input_tam is the length of the dataframe with the main scientifics dissertation, obtained using package bibliorefer.
#' @return The output of the dissert_bib function is the file with the .bib extension, containing the list of dissertation references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
#' @importFrom utils read.csv2
#' @importFrom bibliorefer principal_lister
#' @export
#'
#' @references
#' 1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
#' 2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
#'
#'
#' @examples
#'
#' # Example
#'
#' # File of database
#' file_db <- system.file("extdata","dissertacao.csv", package = "gerefer")
#' separator <- ";"
#'
#' # Parameters of the function
#' input_date <- example_database(file_db, separator)
#' input_tam <- 10
#'
#' #Calls the function monograf_bib
#' dissertlister_bibtex <- dissert_bib(input_date, input_tam)
#' dissertlister_bibtex
#'
#'

dissert_bib <- function(input_date,input_tam){

  # Data entry
  input_date <- input_date
  input_tam <- input_tam

  # Call the function that generates the intermediate information
  gerad_dissert <- function(input_date){

    # Replace dataframe with matrix
    input_entrada <- as.matrix(input_date)

    # Delete NA
    na_retir <- function(input_entr){

      # Data entry
      entrada_base <- input_entr
      entrada_base <- as.data.frame(entrada_base)
      colnames(entrada_base) <- "base"

      # Delete NA
      variavel <- entrada_base$base
      testena <- is.na(variavel)
      padrao <- "TRUE"
      linha_na <- grep(padrao,testena)
      variavel[linha_na] <- ""

      return(variavel)

    }

    # Create the loop indexer
    nomes_colunas <- names(input_date)

    # Create the loop along the columns
    for (i in seq_along(nomes_colunas)){

      input_entr <- nomes_colunas[i]
      names(input_entrada) <- colnames(input_date)
      coluna <- na_retir(input_entrada[,input_entr])
      input_entrada[,i] <- coluna

    }

    # Change format from matrix to dataframe
    tabela <- input_entrada
    tabela <- as.data.frame(input_entrada)
    ##

    # Create the extra table
    n <- length(tabela$autor)
    citacoes <- 1:n
    link <- rep("",n)
    abstract <- rep("",n)
    paginas <- rep("",n)
    volume <- rep("",n)
    extra <- cbind(volume,link,abstract,citacoes)
    extra <- as.data.frame(extra)

    # Create the input table and change the names
    nomes <- c("AU","TI", "edicao", "local", "SO", "PY", "PP",
               "VL","DI","AB","TC")
    baseentrada <- cbind(tabela, extra)
    colnames(baseentrada) <- nomes

    # Call the main list function
    input_dateprin <- baseentrada
    input_tam <- n
    listaprincipal <- principal_lister(input_dateprin,input_tam)
    lista_prin <- listaprincipal[[1]]
    posicao_book <- lista_prin$Article
    posicao_info <- which(posicao_book != "")
    ##

    # Calculating the size of tables
    tamanho <- length(posicao_info)

    # Create the input table and change the name
    tabela_lei <- tabela
    nomes_tabela <- c("autor", "titulo", "subtitulo", "data", "folhas",
                      "tipo", "escola", "endereco", "url", "acesso")
    colnames(tabela_lei) <- nomes_tabela
    ###

    # Call the access date function
    acesso_datas <- function(input_dateace){

      # Remove NA
      na_retir <- function(input_entr){

        # Data entry
        entrada_base <- input_entr
        entrada_base <- as.data.frame(entrada_base)
        colnames(entrada_base) <- "base"

        # Remove NA
        variavel <- entrada_base$base
        testena <- is.na(variavel)
        padrao <- "TRUE"
        linha_na <- grep(padrao,testena)
        variavel[linha_na] <- ""

        return(variavel)

      }

      # Call function to remove NA
      input_entr <- input_dateace
      entrada_data <- na_retir(input_entr)

      # Calculate the column size and generate the corresponding vectors
      n <- length(entrada_data)
      data_acessos <- numeric(n)
      dia_acesso <- numeric(n)

      # Create the loop
      for(i in 1:n){

        if(entrada_data[i] == ""){

          dia_acess <- ""

        }else{

          data_sepa <- strsplit(entrada_data, split = "/")
          data_separ <- data_sepa[[i]]

          # Create the day
          ind_dia <- 1
          dia_separ <- data_separ[ind_dia]

          # Create the month
          ind_mes <- 2
          mes_separ <- data_separ[ind_mes]

          # Create the year
          ind_ano <- 3
          ano_sepa <- data_separ[ind_ano]
          inicio_ano <- 20
          ano_separ <- paste0(inicio_ano,ano_sepa)
          ano_separ <- as.numeric(ano_separ)

          # Generate the access date
          hifen <- "\u002D"
          data_acesso <- paste0(ano_separ, hifen, mes_separ, hifen, dia_separ)
          data_acessos[i] <- data_acesso

          dia_acess <- data_acessos[i]

        }

        dia_acesso[i] <- dia_acess

      }

      return(dia_acesso)

    }

    # Data access function input
    input_dateace <- tabela_lei$acesso
    dia_acesso <- acesso_datas(input_dateace)
    dia_acesso
    ##

    # Create titles and subtitles
    tamanho_titul <- tamanho
    tamanho_subti <- numeric(tamanho_titul)
    titul_artic <- numeric(tamanho_titul)
    subtitul_artic <- numeric(tamanho_titul)

    # Call the function from the authors name
    titulo_minu <- function(enti_artic){

      # Data entry
      tit_arti <- enti_artic

      # Change the letter to lowercase
      titu_minu <- tolower(tit_arti)

      # Separate words
      let_minu <- strsplit(titu_minu," ")

      # Select first letter of words
      prl_min <- let_minu[[1]][1]

      # Separate letter from the first word
      prl_minsep <- strsplit(prl_min, "")

      # Select the first lowercase letter
      prl_minu <- prl_minsep[[1]][1]

      #"‘"=2018
      padrao_aspa1 <- "\u2018"
      test_aspa1 <- grepl(padrao_aspa1, prl_minu)

      #"“"=201C
      padrao_aspa2 <- "\u201C"
      test_aspa2 <- grepl(padrao_aspa2, prl_minu)

      #"'"=0027
      padrao_aspavert1 <- "\u0027"
      test_aspavert1 <- grepl(padrao_aspavert1, prl_minu)

      #"`"=0060
      padrao_apost1 <- "\u0060"
      test_apost1 <- grepl(padrao_apost1, prl_minu)

      #"\""="\0022"
      padrao_apost2 <- "\u0022"
      test_apost2 <- grepl(padrao_apost2, prl_minu)

      #"\\("=0028
      padrao_paren <- "\\u0028"
      test_paren <- grepl(padrao_paren, prl_minu)

      #"#"=0023
      padrao_hash <- "\u0023"
      test_hash <- grepl(padrao_hash, prl_minu)

      if(test_aspa1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_aspa2 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_apost1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_apost2 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_aspavert1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_paren == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_hash == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else{

        prl_minu <- prl_minsep[[1]][1]

      }

      # Capitalize the first letter
      prl_maiu <- toupper(prl_minu)

      # Replace the lowercase letter with the uppercase letter
      tit_artic <- sub(prl_minu,prl_maiu,titu_minu)

      # Return the author's name
      return(tit_artic)

    }

    entitu_artic <- tabela_lei$titulo

    for(i in 1:tamanho){

      enti_artic <- entitu_artic[i]

      # Return the author's name
      padrao_pont <- ": "
      padrao_pont1 <- ":"
      test_subtitu <- grepl(padrao_pont,enti_artic)

      padrao_true <- "TRUE"
      linha_sub <- grep(padrao_true,test_subtitu)
      tamanho_titul <- length(linha_sub)

      # Standardize the page separator
      if(test_subtitu == FALSE){

        titu_artic <- enti_artic
        titu_artic <- titulo_minu(titu_artic)
        subtitu_artic <- ""

      }else{

        titulo_basesepar <- strsplit(enti_artic,
                                     split = padrao_pont)
        comp_subti <- length(titulo_basesepar[[1]])

        if(comp_subti == 2){

          titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
          titu_artic <- titulo_minu(titu_artic)
          subtitu_artic <- titulo_basesepar[[1]][2]
          subtitu_artic <- tolower(subtitu_artic)

        }else{

          titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
          titu_artic <- titulo_minu(titu_artic)
          subtitu_artic <- titulo_basesepar[[1]][2]

          for(k in 3:comp_subti){

            subtitu_artic <- paste0(subtitu_artic, sep = ".",
                                    titulo_basesepar[[1]][k])
            subtitu_artic <- tolower(subtitu_artic)
          }

        }

      }

      titul_artic[i] <- titu_artic
      subtitul_artic[i] <- subtitu_artic

    }
    ##
    # Create the year author identity
    # Separate team authors
    autsep_article <- strsplit(tabela_lei$autor, split = ", ")
    autor_ano <- numeric(tamanho)

    for(i in 1:tamanho){

      autoria <- autsep_article[[i]][1]
      autor_ano[i] <- paste0(autoria,tabela_lei$data[i])

    }
    ##
    # Create the number of pages
    # Remove NA
    na_retir <- function(input_entr){

      # Data entry
      entrada_base <- input_entr
      entrada_base <- as.data.frame(entrada_base)
      colnames(entrada_base) <- "base"

      # Remove NA
      variavel <- entrada_base$base
      testena <- is.na(variavel)
      padrao <- "TRUE"
      linha_na <- grep(padrao,testena)
      variavel[linha_na] <- ""

      return(variavel)

    }

    input_entr <- tabela_lei$folhas
    folha <- na_retir(input_entr)
    folha_comp <- "f."
    espaco <- " "
    folhas_disser <- numeric(tamanho)

    # Create the loop
    for(i in 1:tamanho){

      if(folha[i] == ""){

        folhas_disser[i] <- ""

      }else{

        folhas_disser[i] <- paste0(folha[i], espaco, folha_comp)

      }

    }

    # Creation of variables
    autores <- tabela_lei$autor
    data_disser <- tabela_lei$data
    num_folha <- folhas_disser
    tipo_mest <- tabela_lei$tipo
    escola <- tabela_lei$escola
    endereco <- tabela_lei$endereco
    links <- tabela_lei$url

    # Create the table with the information of interest and change the format
    tabel_bibtexi <- cbind(autor_ano, autores, titul_artic, subtitul_artic,
                           data_disser, num_folha, tipo_mest, escola,
                           endereco, links, dia_acesso)
    tabel_bibtexi <- as.data.frame(tabel_bibtexi)

    # Change column names
    nomes <- c("fonte_ano", "autores", "titulo", "subtitulo", "data_disser",
               "num_folha", "tipo_mest", "escola", "endereco", "links",
               "dataacesso")
    colnames(tabel_bibtexi) <- nomes

    # Create the list
    tabela_bibtex <- list()
    tabela_bibtex <- list(tabel_bibtexi, tamanho)
    names(tabela_bibtex) <- c("tabel_bibtex", "tamanho")

    # Return the information
    return(tabela_bibtex)

  }

  #Call the gerard_dissert function
  tabel_bibte <- gerad_dissert(input_date)

  # Create the variables of interest
  tabel_bibtex <- tabel_bibte[[1]]
  tamanho <- tabel_bibte[[2]]

  # Function that generates the file in bibtex format
  bibtex_lister <- function(tabel_bibtex,indic){

    # Data entry
    input_tabel <- tabel_bibtex
    tabela <- input_tabel
    linha <- indic

    # Reduce database size
    tabela_redu <- tabela[linha,]
    tabela_ent <- tabela_redu

    # Assign input information to variables
    simbolo_entrada <- "@mastersthesis{"
    fonte_ano <- tabela_ent$fonte_ano
    autor <- tabela_ent$autores
    titulo <- tabela_ent$titulo
    subtitulo <- tabela_ent$subtitulo
    data_disser <- tabela_ent$data_disser
    num_folha <- tabela_ent$num_folha
    tipo_mest <- tabela_ent$tipo_mest
    escola <- tabela_ent$escola
    endereco <- tabela_ent$endereco
    link <- tabela_ent$links
    acesso <- tabela_ent$dataacesso

    # Create the elements of the bibtex format structure
    espaco <- "  "
    virgula <- ","
    autorarticle <- "author="
    tituloarticle <- "title="
    subtituloarticle <- "subtitle="
    data_disserarticle <- "year="
    num_folhaarticle <- "pages="
    tipo_mestarticle <- "type="
    escolaarticle <- "school="
    enderecoarticle <- "address="
    linkarticle <- "url="
    acessoarticle <- "urldate="

    #publicacaoart <- "publisher="
    chave_entrada <- "{"
    chave_saida <- "}"

    # Create the bibtex structure for each variable
    chave <- paste0(simbolo_entrada,fonte_ano,virgula)
    autor <- paste0(autorarticle,chave_entrada,autor,
                    chave_saida)
    titulo <- paste0(tituloarticle,chave_entrada,titulo,
                     chave_saida)
    subtitulo <- paste0(subtituloarticle,chave_entrada,subtitulo,
                        chave_saida)
    data_disser <- paste0(data_disserarticle,chave_entrada,data_disser,
                          chave_saida)
    num_folha  <- paste0(num_folhaarticle,chave_entrada,num_folha,
                         chave_saida)
    tipo_mest  <- paste0(tipo_mestarticle ,chave_entrada,tipo_mest,
                         chave_saida)
    escola  <- paste0(escolaarticle,chave_entrada,escola,
                      chave_saida)
    endereco  <- paste0(enderecoarticle,chave_entrada,endereco,
                        chave_saida)
    link <- paste0(linkarticle,chave_entrada,link,
                   chave_saida)
    acesso <- paste0(acessoarticle,chave_entrada,acesso,
                     chave_saida)

    # Create bibtex format for articles
    referen_bibtex <- paste0(chave,"\n",
                             espaco, autor, virgula, "\n",
                             espaco, titulo, virgula, "\n",
                             espaco, subtitulo, virgula, "\n",
                             espaco, data_disser, virgula, "\n",
                             espaco, num_folha, virgula, "\n",
                             espaco, tipo_mest, virgula, "\n",
                             espaco, escola, virgula, "\n",
                             espaco, endereco, virgula, "\n",
                             espaco, link, virgula, "\n",
                             espaco, acesso, "\n", chave_saida,
                             espaco, collapse = ",\n")

    # Returns the file in bibtex format
    return(referen_bibtex)
  }

  arquivo_bibtex <- c()
  # Create the loop to generate the list of bibtex files
  for(i in 1:tamanho){

    # Create the parameter linked to the index
    indic <- i

    # Call the function that converts to bibtex format
    refer_bibtex <- bibtex_lister(tabel_bibtex,indic)
    arquivo_bibtex[i] <- refer_bibtex

  }

  # Return the value of the variable
  lista_final <- arquivo_bibtex

  return(lista_final)

}


