% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic_files.R
\name{mosaic_files}
\alias{mosaic_files}
\title{Stitches together files into a single raster
Requires a target directory of files that can be read with raster::raster(), e.g. .asc files, or a directory of .zip files containing these files}
\usage{
mosaic_files(
  path,
  extract_zip = FALSE,
  file_match = ".*.asc",
  zip_file_match = ".*.zip",
  raster_output_file = "mosaic_out.raster",
  file_crs = NULL,
  raster_todisk = FALSE
)
}
\arguments{
\item{path}{path to files that are to be stitched together}

\item{extract_zip}{\code{FALSE} to target .asc files, \code{TRUE} if your .asc files are zipped.}

\item{file_match}{regex pattern to match .asc files, either in \code{path} or in zip files.}

\item{zip_file_match}{regex pattern to match .zip files}

\item{raster_output_file}{raster file to be created (will overwrite existing files)}

\item{file_crs}{projection string of the input files. Output will always be WGS84.}

\item{raster_todisk}{Setting \code{TRUE} will set \code{rasterOptions(todisk=TRUE)}, which can help with memory issues.}
}
\value{
TRUE
}
\description{
Stitches together files into a single raster
Requires a target directory of files that can be read with raster::raster(), e.g. .asc files, or a directory of .zip files containing these files
}
\examples{
# Merges two small example .asc files of LIDAR data
# from https://environment.data.gov.uk (open government licence)

path_to_files <- system.file("extdata/example_asc", package = "geoviz")

path_to_output <- tempdir()

mosaic_files(path_to_files,
             raster_output_file = paste0(path_to_output, '/mosaic_out.raster', sep = ''),
             extract_zip = TRUE, file_crs = "+init=epsg:27700")

raster_mosaic <- raster::raster(paste0(path_to_output, '/mosaic_out.gri', sep = ''))
}
