% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractals.R
\name{sierpinski}
\alias{sierpinski}
\title{Sierpinski carpet}
\usage{
sierpinski(n = 5)
}
\arguments{
\item{n}{an integer value controling the number of recursive
levels.}
}
\value{
a square matrix with 0s and 1s.
}
\description{
Returns a matrix of 0s and 1s that form a Sierpinski
    carpet. This is a two dimensional fractal, which is generated
    using a recursive algorithm that is built on a grid of eight
    black squares surrounding a white square. Each level of
    recursion replaces each black square by the same pattern.
}
\examples{
g <- sierpinski(n=5)
image(g,col=c('white','black'),axes=FALSE,asp=1)
}
