% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geary.R
\name{gr}
\alias{gr}
\title{The Geary Ratio}
\source{
Chun, Yongwan, and Daniel A. Griffith. Spatial Statistics and Geostatistics: Theory and Applications for Geographic Information Science and Technology. Sage, 2013.

Qing, Luo and Griffith, Daniel A. and Wu, Huayi. "The Moran Coefficient and Geary Ratio: Some mathematical and numerical comparisons." Proceedings of the 13th International Conference on Geocomputation. Richardson, TX (USA), May 20-23, 2015. \url{http://www.geocomputation.org/2015/}

Geary, R. C. "The contiguity ratio and statistical mapping." The Incorporated Statistician 5, no. 3 (1954): 115-127_129-146.

Unwin, Antony. "Geary's Contiguity Ratio." The Economic and Social Review 27, no. 2 (1996): 145-159.
}
\usage{
gr(x, w, digits = 3, na.rm = FALSE, warn = TRUE)
}
\arguments{
\item{x}{Numeric vector of length \code{n}. By default, this will be standardized using the \code{scale} function.}

\item{w}{An \verb{n x n} spatial connectivity matrix. See \link[geostan]{shape2mat}.}

\item{digits}{Number of digits to round results to.}

\item{na.rm}{If \code{na.rm = TRUE}, observations with \code{NA} values will be dropped from both \code{x} and \code{w}.}

\item{warn}{If \code{FALSE}, no warning will be printed to inform you when observations with \code{NA} values have been dropped, or if any observations without neighbors have been found.}
}
\description{
An index for spatial autocorrelation. Complete spatial randomness (lack of spatial pattern) is indicated by a Geary Ratio (GR) of 1; positive autocorrelation moves the index towards zero, while negative autocorrelation will push the index towards 2.
}
\details{
The Geary Ratio is an index of spatial autocorrelation. The
numerator contains a series of sums of squared deviations, which
will be smaller when each observation is similar to its
neighbors. This term makes the index sensitive to local outliers,
which is advantageous for detecting such outliers and for measuring
negative autocorrelation. The denominator contains the total sum of
squared deviations from the mean value. Hence, under strong
positive autocorrelation, the GR approaches zero. Zero spatial
autocorrelation is represented by a GR of 1. Negative
autocorrelation pushes the GR above 1, towards 2.  \deqn{GR =
\frac{n-1}{2K} \frac{M}{D}} \deqn{M = \sum_i \sum_j w_{i,j} (x_i -
x_j)^2 } \deqn{D = \sum_i (x_i - \overline{x})^2 } Observations
with no neighbors are removed before calculating the GR. The
alternative is for those observations to contribute zero to the
numerator---but zero is not a neutral value, it represents strong
positive autocorrelation.
}
\examples{
data(georgia)
x <- log(georgia$income)
w <- shape2mat(georgia, "W")
gr(x, w)


}
