% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{se_log}
\alias{se_log}
\title{Standard error of log(x)}
\usage{
se_log(x, se, method = c("mc", "delta"), nsim = 5000, bounds = c(0, Inf))
}
\arguments{
\item{x}{An estimate}

\item{se}{Standard error of \code{x}}

\item{method}{The \code{"delta"} method uses a Taylor series approximation; the default method, \code{"mc"}, uses a simple monte carlo method.}

\item{nsim}{Number of draws to take if \code{method = "mc"}.}

\item{bounds}{Lower and upper bounds for the variable, used in the monte carlo method. Must be a length-two numeric vector with lower bound greater than or equal to zero (i.e. \code{c(lower, upper)} as in default \code{bounds = c(0, Inf)}.}
}
\value{
Numeric vector of standard errors
}
\description{
Transform the standard error of \code{x} to standard error of \code{log(x)}.
}
\details{
The delta method returns \code{x^(-1) * se}. The monte carlo method is detailed in the examples section.
}
\examples{
data(georgia)
x = georgia$college
se = georgia$college.se

lse1 = se_log(x, se)
lse2 = se_log(x, se, method = "delta")
plot(lse1, lse2); abline(0, 1)

# the monte carlo method
x = 10
se = 2
z = rnorm(n = 20e3, mean = x,  sd = se)
l.z = log(z)
sd(l.z)
se_log(x, se, method = "mc")
se_log(x, se, method = "delta")
}
