% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-spatial-join.R
\name{raster_to_raster_ops}
\alias{raster_to_raster_ops}
\title{Raster to Raster Operations}
\usage{
raster_to_raster_ops(
  raster1,
  raster2,
  operation = "overlay",
  align_method = "resample",
  summary_function = "mean",
  handle_na = "propagate",
  mask_value = NA,
  output_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{raster1}{First raster (SpatRaster or file path)}

\item{raster2}{Second raster (SpatRaster or file path)}

\item{operation}{Character. Mathematical operation:
\itemize{
\item \strong{"add"}: Add rasters (raster1 + raster2)
\item \strong{"subtract"}: Subtract rasters (raster1 - raster2)
\item \strong{"multiply"}: Multiply rasters (raster1 * raster2)
\item \strong{"divide"}: Divide rasters (raster1 / raster2)
\item \strong{"mask"}: Mask raster1 with raster2
\item \strong{"overlay"}: Combine with summary function
\item \strong{"difference"}: Absolute difference |raster1 - raster2|
\item \strong{"ratio"}: Ratio raster1 / raster2 (with zero handling)
}}

\item{align_method}{Character. How to align mismatched rasters:
\itemize{
\item \strong{"resample"}: Resample raster2 to match raster1 (default)
\item \strong{"crop"}: Crop both to common extent
\item \strong{"extend"}: Extend smaller raster to match larger
\item \strong{"project"}: Reproject raster2 to raster1 CRS
}}

\item{summary_function}{Character. Function for overlay operation}

\item{handle_na}{Character. How to handle NA values:
\itemize{
\item \strong{"propagate"}: NA + value = NA (default)
\item \strong{"ignore"}: Skip NAs in calculations
\item \strong{"zero"}: Treat NAs as zero
}}

\item{mask_value}{Numeric. Value to use for masking (default: NA)}

\item{output_file}{Character. Optional output file path}

\item{verbose}{Logical. Print processing details}
}
\value{
SpatRaster with operation results
}
\description{
Specialized function for mathematical and overlay operations between rasters.
Handles alignment, projection, and complex operations with comprehensive
error handling and performance optimization.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Mathematical operations
sum_raster <- raster_to_raster_ops("ndvi.tif", "evi.tif", "add")
diff_raster <- raster_to_raster_ops("before.tif", "after.tif", "subtract")

# Masking operations
masked <- raster_to_raster_ops("data.tif", "mask.tif", "mask")

# Complex overlay with alignment
overlay <- raster_to_raster_ops(
  raster1 = "fine_res.tif",
  raster2 = "coarse_res.tif",
  operation = "overlay",
  align_method = "resample",
  summary_function = "mean",
  verbose = TRUE
)
}

}
