% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-correlation.R
\name{analyze_variable_correlations}
\alias{analyze_variable_correlations}
\title{Analyze correlations between multiple variables}
\usage{
analyze_variable_correlations(
  variable_list,
  output_folder = NULL,
  region_boundary = NULL,
  method = "pearson",
  create_plots = TRUE
)
}
\arguments{
\item{variable_list}{Named list of raster variables}

\item{output_folder}{Output directory for results}

\item{region_boundary}{Optional region boundary}

\item{method}{Correlation method}

\item{create_plots}{Create correlation plots}
}
\value{
List with correlation results
}
\description{
Analyze correlations between multiple raster variables and create
correlation matrices and plots.
}
\examples{
\dontrun{
# These examples require directory structures with multiple data files
# Analyze correlations between multiple variables
variables <- list(
  ndvi = "ndvi.tif",
  nitrogen = "soil_nitrogen.tif",
  elevation = "dem.tif",
  precipitation = "precip.tif"
)

correlation_results <- analyze_variable_correlations(
  variables,
  output_folder = "correlations/",
  region_boundary = "Ohio"
)
}

}
