% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.coords.r
\name{rotate.coords}
\alias{rotate.coords}
\title{Rotate or flip landmark or coordinate configurations}
\usage{
rotate.coords(
  A,
  type = c("flipX", "flipY", "rotateC", "rotateCC"),
  index = NULL
)
}
\arguments{
\item{A}{One of either an array of landmark coordinates (p, 2, n dimensions for n specimens and p 2D points),
a class gpagen object, or a p x 2 matrix for a single specimen.}

\item{type}{The type of rotation or flip to be performed.  Specimens can be flipped with respect to x or y axes,
or rotated clockwise (C) or counter-clockwise (CC).}

\item{index}{An index to indicate which specimens should be rotated or flipped.  If NULL (default)
all specimens are rotated.  A binary index (0 = do not rotate; 1 = rotate) as a vector with the same length as 
the number of specimens will direct which specimens are manipulated.  A factor with two levels or a numeric vector with 
two any two values can also be used.  
The second level (or larger value) will be the level manipulated.  For example, a factor with levels = c("a", "b") 
will rotate specimens matching level "b".  This function might be useful for reflecting specimens with bilateral structures.}
}
\description{
Function to rotate or flip 2D landmark or coordinate configurations to re-orientate them, as desired.
}
\details{
This function will allow a user to rotate or flip one or several configurations of raw landmarks or
Procrustes residuals from GPA, as desired.  This function only works with two-dimensional configurations.
This is a useful tool if importing coordinates or performing GPA produces undesired orientations (such as flipping
configurations upside down, when aligning them to their PCs).  It is not as useful with 3D coordinates, as the plotting tools 
for 3D coordinates already have built-in rotation capabilities.

The function returns an object of the same class as input, after having rotated or flipped
the coordinates of each specimen.  If multiple steps are required, the function
can be used in a recursive fashion.
}
\examples{
data(plethodon)
Y.gpa <- gpagen(plethodon$land)
plot(Y.gpa)
Y.gpa2 <- rotate.coords(Y.gpa, "flipX")
plot(Y.gpa2)
Y.gpa3 <- rotate.coords(Y.gpa2, "rotateCC")
plot(Y.gpa3)

spec1 <- Y.gpa$coords[,,1]
plot(spec1, asp = 1)
spec1 <- rotate.coords(spec1, "flipY")
plot(spec1, asp = 1)

specs1to3 <- Y.gpa$coords[,,1:3]
plotAllSpecimens(specs1to3)
specs1to3 <- rotate.coords(specs1to3, "rotateC")
plotAllSpecimens(specs1to3)
}
\author{
Michael Collyer
}
\keyword{utilities}
