% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_reflect.R
\name{gt_reflect}
\alias{gt_reflect}
\title{Reflect geometric objects}
\usage{
gt_reflect(obj, angle, fid = NULL, update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to reflect.}

\item{angle}{[\code{numeric(1)}]\cr the counter-clockwise angle by which the
reflection axis shall be rotated (can be negative to rotate clockwise).}

\item{fid}{[\code{integerish(.)}]\cr in case only a subset of features shall
be rotated, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after rotation.}
}
\value{
\code{geom} of the reflected \code{obj}.
}
\description{
Reflect geometric objects across a reflection axis.
}
\details{
The reflection axis is a straight line that goes through the plot
  origin with the given angle, where positive angles open towards the
  positive y-axis and negative angles open up towards the negative y-axis.
}
\examples{
# reflect several features
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_reflect(obj = gtGeoms$polygon, angle = 45,
                      update = FALSE)
visualise(newPoly, linecol = "green", new = FALSE)

# reflect a single feature
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_reflect(obj = gtGeoms$polygon, angle = 90, fid = 2,
                      update = FALSE)
visualise(newPoly, linecol = "green", new = FALSE)
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
