% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryRequirement.R
\docType{class}
\name{ISOImageryRequirement}
\alias{ISOImageryRequirement}
\title{ISOImageryRequirement}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery requirement
}
\description{
ISOImageryRequirement

ISOImageryRequirement
}
\examples{
   md <- ISOImageryRequirement$new()
   md$setIdentifier("identifier")
   #add citation
   rp1 <- ISOResponsibleParty$new()
   rp1$setIndividualName("someone1")
   rp1$setOrganisationName("somewhere1")
   rp1$setPositionName("someposition1")
   rp1$setRole("pointOfContact")
   contact1 <- ISOContact$new()
   phone1 <- ISOTelephone$new()
   phone1$setVoice("myphonenumber1")
   phone1$setFacsimile("myfacsimile1")
   contact1$setPhone(phone1)
   address1 <- ISOAddress$new()
   address1$setDeliveryPoint("theaddress1")
   address1$setCity("thecity1")
   address1$setPostalCode("111")
   address1$setCountry("France")
   address1$setEmail("someone1@theorg.org")
   contact1$setAddress(address1)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://www.somewhereovertheweb.org")
   res$setName("somename")
   contact1$setOnlineResource(res)
   rp2 <- ISOResponsibleParty$new()
   rp2$setIndividualName("someone2")
   rp2$setOrganisationName("somewhere2")
   rp2$setPositionName("someposition2")
   rp2$setRole("pointOfContact")
   contact2 <- ISOContact$new()
   phone2 <- ISOTelephone$new()
   phone2$setVoice("myphonenumber2")
   phone2$setFacsimile("myfacsimile2")
   contact1$setPhone(phone2)
   address2 <- ISOAddress$new()
   address2$setDeliveryPoint("theaddress2")
   address2$setCity("thecity2")
   address2$setPostalCode("111")
   address2$setCountry("France")
   address2$setEmail("someone2@theorg.org")
   contact2$setAddress(address2)
   contact2$setOnlineResource(res)
   rp2$setContactInfo(contact2)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(ISOdate(2015,1,1))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp1)
   md$setCitation(ct)
   md$addRequestor(rp1)
   md$addRecipient(rp2)
   md$setPriority("highImportance")
   
   rd <- ISOImageryRequestedDate$new()
   rd$setRequestedDateOfCollection(Sys.time())
   rd$setLatestAcceptableDate(Sys.time())
   md$setRequestedDate(rd)
   md$setExpiryDate(Sys.time())
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{requirement}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{ISOImageryRequirement}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{citation}}{citation [1..1]: ISOCitation}

\item{\code{identifier}}{identifier [1..1]: ISOMetaIdentifier}

\item{\code{requestor}}{requestor [0..*]: ISOResponsibleParty}

\item{\code{recipient}}{recipient [0..*]: ISOResponsibleParty}

\item{\code{priority}}{priority [1..1]: ISOImageryPriority}

\item{\code{requestedDate}}{requestedDate [1..1]: ISOImageryRequestedDate}

\item{\code{expiryDate}}{expiryDate [1..1]: POSIXt}

\item{\code{satisfiedPlan}}{satisfiedPlan [0..*]: ISOImageryPlan}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOImageryRequirement-new}{\code{ISOImageryRequirement$new()}}
\item \href{#method-ISOImageryRequirement-setCitation}{\code{ISOImageryRequirement$setCitation()}}
\item \href{#method-ISOImageryRequirement-setIdentifier}{\code{ISOImageryRequirement$setIdentifier()}}
\item \href{#method-ISOImageryRequirement-addRequestor}{\code{ISOImageryRequirement$addRequestor()}}
\item \href{#method-ISOImageryRequirement-delRequestor}{\code{ISOImageryRequirement$delRequestor()}}
\item \href{#method-ISOImageryRequirement-addRecipient}{\code{ISOImageryRequirement$addRecipient()}}
\item \href{#method-ISOImageryRequirement-delRecipient}{\code{ISOImageryRequirement$delRecipient()}}
\item \href{#method-ISOImageryRequirement-setPriority}{\code{ISOImageryRequirement$setPriority()}}
\item \href{#method-ISOImageryRequirement-setRequestedDate}{\code{ISOImageryRequirement$setRequestedDate()}}
\item \href{#method-ISOImageryRequirement-setExpiryDate}{\code{ISOImageryRequirement$setExpiryDate()}}
\item \href{#method-ISOImageryRequirement-addSatisfiedPlan}{\code{ISOImageryRequirement$addSatisfiedPlan()}}
\item \href{#method-ISOImageryRequirement-delSatisfiedPlan}{\code{ISOImageryRequirement$delSatisfiedPlan()}}
\item \href{#method-ISOImageryRequirement-clone}{\code{ISOImageryRequirement$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-setCitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-setCitation}{}}}
\subsection{Method \code{setCitation()}}{
Set citation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$setCitation(citation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citation}}{object of class \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-setIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-setIdentifier}{}}}
\subsection{Method \code{setIdentifier()}}{
Set identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$setIdentifier(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{object of class \link{ISOMetaIdentifier} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-addRequestor"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-addRequestor}{}}}
\subsection{Method \code{addRequestor()}}{
Adds requestor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$addRequestor(requestor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{requestor}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-delRequestor"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-delRequestor}{}}}
\subsection{Method \code{delRequestor()}}{
Deletes requestor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$delRequestor(requestor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{requestor}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-addRecipient"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-addRecipient}{}}}
\subsection{Method \code{addRecipient()}}{
Adds recipient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$addRecipient(recipient)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recipient}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-delRecipient"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-delRecipient}{}}}
\subsection{Method \code{delRecipient()}}{
Deletes recipient
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$delRecipient(recipient)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recipient}}{object of class \link{ISOResponsibleParty}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-setPriority"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-setPriority}{}}}
\subsection{Method \code{setPriority()}}{
Set priority
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$setPriority(priority)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{priority}}{object of class \link{ISOImageryPriority} pr any \link{character}
among values returned by \code{ISOImageryPriority$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-setRequestedDate"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-setRequestedDate}{}}}
\subsection{Method \code{setRequestedDate()}}{
Set requested date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$setRequestedDate(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{object of class \link{ISOImageryRequestedDate}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-setExpiryDate"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-setExpiryDate}{}}}
\subsection{Method \code{setExpiryDate()}}{
Set expiry date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$setExpiryDate(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{object of class \link{POSIXct}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-addSatisfiedPlan"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-addSatisfiedPlan}{}}}
\subsection{Method \code{addSatisfiedPlan()}}{
Adds satisfied plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$addSatisfiedPlan(plan)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plan}}{object of class \link{ISOImageryPlan}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-delSatisfiedPlan"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-delSatisfiedPlan}{}}}
\subsection{Method \code{delSatisfiedPlan()}}{
Deletes satisfied plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$delSatisfiedPlan(plan)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plan}}{object of class \link{ISOImageryPlan}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryRequirement-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryRequirement-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryRequirement$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
