% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODataFile.R
\docType{class}
\name{ISODataFile}
\alias{ISODataFile}
\title{ISODataFile}
\format{\code{\link{R6Class}} object.}
\usage{
ISODataFile
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO DataFile
}
\description{
ISODataFile
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISODataFile}}
 }
 \item{\code{setFileName(fileName)}}{
   Set the file name, object of class \code{\link{ISOFileName}}
 }
 \item{\code{setFileDescription(fileDescription, locales)}}{
   Set the file description, object of class 'character'. Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setFileType(type)}}{
   Set the file type, object of class \code{\link{ISOMimeFileType}}.
 }
 \item{\code{addFeatureType(featureType)}}{
   Add a feature type, object of class \code{\link{ISOLocalName}} or \code{link{ISOScopedName}},
   or eventually a 'character' in which case the featureType will be coerced to a local name.
 }
 \item{\code{delFeatureType(featureType)}}{
   Deletes a feature type, object of class \code{\link{ISOLocalName}} or \code{link{ISOScopedName}},
   or eventually a 'character' in which case the featureType will be coerced to a local name.
 }
 \item{\code{setFileFormat(fileFormat)}}{
   Set the file format, object of class \code{\link{ISOFormat}}
 }
}
}

\examples{
  md <- ISODataFile$new()
  md$setFileName(ISOFileName$new(file = "someuri", name = "filename"))
  md$setFileDescription("description")
  md$setFileType(ISOMimeFileType$new(type = "somemimetype", name = "Mime type name"))
  md$addFeatureType("feature_type")
  f <- ISOFormat$new()
  f$setName("name")
  f$setVersion("1.0")
  f$setAmendmentNumber("2")
  f$setSpecification("specification")
  md$setFileFormat(f)
  xml <- md$encode()

}
\references{
ISO/TS 19139:2007 Geographic information -- XML
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{data}
\keyword{file}
