% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryOperation.R
\docType{class}
\name{ISOImageryOperation}
\alias{ISOImageryOperation}
\title{ISOImageryOperation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryOperation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery Operation
}
\description{
ISOImageryOperation
}
\section{Fields}{

\describe{
\item{\code{description}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{citation}}{[\code{\link{ISOCitation}}]}

\item{\code{identifier}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{status}}{[\code{\link{ISOStatus}}]}

\item{\code{type}}{[\code{\link{ISOImageryOperationType}}]}

\item{\code{parentOperation}}{[\code{\link{ISOImageryOperation}}]}

\item{\code{childOperation}}{[\code{list} of \code{\link{ISOImageryOperation}}]}

\item{\code{platform}}{[\code{list} of \code{\link{ISOImageryPlatform}}]}

\item{\code{objective}}{[\code{list} of \code{\link{ISOImageryObjective}}]}

\item{\code{plan}}{[\code{list} of \code{\link{ISOImageryPlan}}]}

\item{\code{significantEvent}}{[\code{list} of \code{\link{ISOImageryEvent}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryOperation}}
 }
 \item{\code{setDescription(description, locales)}}{
   Sets a description (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setCitation(citation)}}{
   Sets a citation, object of class \code{\link{ISOCitation}}
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets an identifier, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setStatus(status)}}{
   Sets status, object of class \code{\link{ISOStatus}} or 'character', among values given 
   by \code{ISOStatus$values()} or any free text code
 }
 \item{\code{setType(type)}}{
   Sets the operation type, object of class \code{\link{ISOImageryOperationType}}, or 'character'
   amont values given by \code{ISOImageryOperationType$values()}, or any free text code.
 }
 \item{\code{setParentOperation(operation)}}{
   Sets the parent operation, object of class \code{\link{ISOImageryOperation}}.
 }
 \item{\code{addChildOperation(operation)}}{
   Adds a child operation, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{delChildOperation(operation)}}{
   Deletes a child operation, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{addPlatform(platform)}}{
   Adds a platform, object of class \code{\link{ISOImageryPlatform}}
 }
 \item{\code{delPlatform(platform)}}{
   Deletes a platform, object of class \code{\link{ISOImageryPlatform}}
 }
 \item{\code{addObjective(objective)}}{
   Adds an objective object of class \code{\link{ISOImageryObjective}}
 }
 \item{\code{delObjective(objective)}}{
   Deletes an objective, object of class \code{\link{ISOImageryObjective}}
 }
 \item{\code{setPlan(plan)}}{
   Sets a plan, object of class \code{\link{ISOImageryPlan}}
 }
 \item{\code{addSignificantEvent(event)}}{
   Adds a significant event, object of class \code{\link{ISOImageryEvent}}
 }
 \item{\code{delSignificantEvent(event)}}{
   Deletes a significant event, object of class \code{\link{ISOImageryEvent}}
 }
}
}

\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{Operation}
\keyword{imagery}
