% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOStandardOrderProcess.R
\docType{class}
\name{ISOStandardOrderProcess}
\alias{ISOStandardOrderProcess}
\title{ISOStandardOrderProcess}
\format{\code{\link{R6Class}} object.}
\usage{
ISOStandardOrderProcess
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO StandardOrderProcess
}
\description{
ISOStandardOrderProcess
}
\section{Fields}{

\describe{
\item{\code{fees}}{}

\item{\code{plannedAvailableDateTime}}{}

\item{\code{orderingInstructions}}{}

\item{\code{turnaround}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOStandardOrderProcess
 }
 \item{\code{setFees(fees)}}{
   Sets fees, object of class \code{character}
 }
 \item{\code{setPlannedAvailableDateTime(dateTime)}}{
   Sets planned available datetime, object of class \code{c('POSIXct','POSIXlt')}
 }
 \item{\code{setOrderingInstructions(instructions)}}{
   Sets ordering instructions, object of class \code{character}
 }
 \item{\code{setTurnaround(turnaround)}}{
   Sets turnaround, object of class \code{character}
 }
}
}
\examples{
md <- ISOStandardOrderProcess$new()
  md$setFees("fees")
  md$setPlannedAvailableDateTime(ISOdate(2017,7,5,12,0,0))
  md$setOrderingInstructions("instructions")
  md$setTurnaround("turnaround")
  xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{StandardOrderProcess}

