% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOProcessStep.R
\docType{class}
\name{ISOProcessStep}
\alias{ISOProcessStep}
\title{ISOProcessStep}
\format{\code{\link{R6Class}} object.}
\usage{
ISOProcessStep
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ProcessStep
}
\description{
ISOProcessStep
}
\section{Fields}{

\describe{
\item{\code{description}}{}

\item{\code{rationale}}{}

\item{\code{dateTime}}{}

\item{\code{processor}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOProcessStep
 }
 \item{\code{setDescription(description)}}{
   Sets the process step description
 }
 \item{\code{setRationale(rationale)}}{
   Sets the process step rationale
 }
 \item{\code{setDateTime(dateTime)}}{
   Sets the date time
 }
 \item{addProcessor(processor)}{
   Adds a processor (object of class \code{ISOResponsibleParty})
 }
 \item{delProcessor(processor)}{
  Deletes a processor
 }
 \item{addSource(source)}{
   Adds a source (object of class \code{ISOSource})
 }
 \item{delSource(source)}{
  Deletes a source
 }
}
}
\examples{
ps <- ISOProcessStep$new()
  ps$setDescription("description")
  ps$setRationale("rationale")
  ps$setDateTime( ISOdate(2015, 1, 1, 23, 59, 59))
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone") #and more responsible party properties..
  ps$addProcessor(rp)
  xml <- ps$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{process}
\keyword{step}

