% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojsonlint.R
\name{geojson_lint}
\alias{geojson_lint}
\title{Validate GeoJSON using geojsonlint.com web service}
\usage{
geojson_lint(x, inform = FALSE, error = FALSE, ...)
}
\arguments{
\item{x}{Input, a geojson character string, json object, or file or
url pointing to one of the former}

\item{inform}{(logical) When geojson is invalid, return reason why
(\code{TRUE}) or don't return reason (\code{FALSE}). Default: \code{FALSE}}

\item{error}{(logical) Throw an error on parse failure? If \code{TRUE}, then
function returns \code{TRUE} on success, and \code{stop} with the
error message on error. Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET} or
\link[crul:verb-POST]{crul::verb-POST}}
}
\value{
\code{TRUE} or \code{FALSE}. If \code{inform=TRUE} an attribute
of name \code{errors} is added with error information
}
\description{
Validate GeoJSON using geojsonlint.com web service
}
\details{
Uses the web service at \url{http://geojsonlint.com}
}
\examples{
\dontrun{
library(jsonlite)

# From a json character string
## good
geojson_lint('{"type": "Point", "coordinates": [-100, 80]}')
json_good <- minify('{"type": "Point", "coordinates": [-100, 80]}')
geojson_lint(json_good)
## bad
geojson_lint('{"type": "Rhombus", "coordinates": [[1, 2], [3, 4], [5, 6]]}')
json_bad <- minify(
 '{"type": "Rhombus", "coordinates": [[1, 2], [3, 4], [5, 6]]}')
geojson_lint(json_bad)

# A file
file <- system.file("examples", "zillow_or.geojson", package = "geojsonlint")
geojson_lint(x = as.location(file))

# A URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
geojson_lint(as.location(url))

# toggle whether reason for validation failure is given back
geojson_lint('{ "type": "FeatureCollection" }')
geojson_lint('{ "type": "FeatureCollection" }', inform = TRUE)

# toggle whether to stop with error message
geojson_lint('{ "type": "FeatureCollection" }')
geojson_lint('{ "type": "FeatureCollection" }', inform = TRUE)
if (interactive()) {
  geojson_lint('{ "type": "FeatureCollection" }', error = TRUE)
}
}
}
