% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{properties}
\alias{properties}
\alias{properties_add}
\alias{properties_get}
\title{Add properties, crs, and bounding box}
\usage{
properties_add(x, ...)

properties_get(x, property)
}
\arguments{
\item{x}{An object of class \code{geojson}}

\item{...}{Properties to be added, supports NSE as well as SE}

\item{property}{(character) property name}
}
\description{
Add properties, crs, and bounding box
}
\examples{
# add properties
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
(y <- linestring(x))
y \%>\% feature() \%>\% properties_add(population = 1000)

# get property
x <- y \%>\% feature() \%>\% properties_add(population = 1000)
properties_get(x, property = 'population')
}
\references{
\url{http://geojson.org/geojson-spec.html}
}

