% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sean.R
\name{sean}
\alias{sean}
\title{Calculate sensitivity analysis on cropland harvested area fraction}
\usage{
sean(
  rast,
  global = TRUE,
  geoscale,
  agg_methods = c("sum", "mean"),
  dist_method = "geodesic",
  link_threshold = 0,
  host_density_threshold = 0,
  res = reso(),
  maps = TRUE,
  outdir = tempdir()
)
}
\arguments{
\item{rast}{Raster object which will be used in analysis.}

\item{global}{Logical. \code{TRUE} if global analysis, \code{FALSE} otherwise.
Default is \code{TRUE}}

\item{geoscale}{Vector. Geographical coordinates
in the form of c(Xmin, Xmax, Ymin, Ymax)}

\item{agg_methods}{vector. Aggregation methods}

\item{dist_method}{character. One of the values from \code{\link[=dist_methods]{dist_methods()}}}

\item{link_threshold}{numeric. A threshold value for link}

\item{host_density_threshold}{A host density threshold value}

\item{res}{numeric.
resolution at which operations will run.
Default is \code{\link[=reso]{reso()}}}

\item{maps}{logical. \code{TRUE} if maps are to be plotted, \code{FALSE} otherwise}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
A list of calculated CCRI values using negative exponential
}
\description{
This function calculates sensitivity analysis on cropland harvested area fraction based on provided parameters.
Some parameters are only accessible from \code{paramters.yaml} and uses value from here
}
\details{
When \code{global = TRUE}, \code{geoscale} is ignored and \code{\link[=global_scales]{global_scales()}} is used
}
\examples{
\donttest{
avocado <- cropharvest_rast("avocado", "monfreda")
risk_indexes <- sean(avocado)
}
}
\references{
Yanru Xing, John F Hernandez Nopsa, Kelsey F Andersen, Jorge L Andrade-Piedra, Fenton D Beed,
Guy Blomme, Mónica Carvajal-Yepes, Danny L Coyne, Wilmer J Cuellar, Gregory A Forbes,
Jan F Kreuze, Jürgen Kroschel, P Lava Kumar, James P Legg, Monica Parker, Elmar Schulte-Geldermann,
Kalpana Sharma, Karen A Garrett,
\emph{Global Cropland Connectivity: A Risk Factor for Invasion and Saturation by Emerging Pathogens and Pests},
BioScience, Volume 70, Issue 9, September 2020, Pages 744–758,
\doi{10.1093/biosci/biaa067}

Hijmans R (2023). \emph{terra: Spatial Data Analysis}.
R package version 1.7-46, \url{https://CRAN.R-project.org/package=terra}
}
\seealso{
Uses \code{\link[=connectivity]{connectivity()}}
}
