% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param_metrics.R
\name{nn_sum}
\alias{nn_sum}
\alias{node_strength}
\alias{betweeness}
\alias{ev}
\alias{degree}
\alias{closeness}
\alias{pagerank}
\title{Calculation on network matrix.}
\usage{
nn_sum(crop_dm, we)

node_strength(crop_dm, we)

betweeness(crop_dm, we)

ev(crop_dm, we)

degree(crop_dm, we)

closeness(crop_dm, we)

pagerank(crop_dm, we)
}
\arguments{
\item{crop_dm}{Distance matrix.
In the internal workflow,
the distance matrix comes is a result of operations within \code{\link[=sean]{sean()}} and risk functions.}

\item{we}{Weight in percentage.}
}
\value{
Matrix with the mean value based on the assigned weight.
}
\description{
These are basically an abstraction of functions under the \link{igraph} package.
The functions included in this abstraction are:
\itemize{
\item \code{nn_sum()}: Calculates the sum of nearest neighbors \code{\link[igraph:knn]{igraph::graph.knn()}}.
\item \code{node_strength()}: Calculates the sum of edge weights of adjacent nodes \code{\link[igraph:strength]{igraph::graph.strength()}}.
\item \code{betweeness()}: Calculates the vertex and edge betweenness based on the number of geodesics
\code{\link[igraph:betweenness]{igraph::betweenness()}}.
\item \code{ev()}: Calculates the eigenvector centrality of positions within the network \code{\link[igraph:eigen_centrality]{igraph::evcent()}}.
\item \code{closeness()}: measures how many steps is required to access every other vertex from a given vertex
\code{\link[igraph:closeness]{igraph::closeness()}}.
\item \code{degree()}: number of adjacent edges \code{\link[igraph:degree]{igraph::degree()}}.
\item \code{pagerank()}: page rank score for vertices \code{\link[igraph:page_rank]{igraph::page_rank()}}.
}
}
\seealso{
Other metrics: 
\code{\link{supported_metrics}()}
}
\concept{metrics}
