% Generated by roxygen2 (4.0.2): do not edit by hand
\name{geocodeHERE_batch_upload}
\alias{geocodeHERE_batch_upload}
\title{Bulk upload addresses to Nokia HERE batch geocoding API}
\usage{
geocodeHERE_batch_upload(address_string, email_address, App_id = "",
  App_code = "", quiet = TRUE)
}
\arguments{
\item{address_string}{Character string containing the addresses to be geocoded. Output from 'format_vec_for_upload(...)}

\item{email_address}{Character string containing an email address. Nokia will email you here when the job is done.}

\item{App_id}{App_id to use the production HERE API. Get one here... http://developer.here.com/get-started. If left blank, will default to demo key with an unknown usage limit.}

\item{App_code}{App_code to use the production HERE API. Get one here... http://developer.here.com/get-started. If left blank, will default to demo key with an unknown usage limit.}

\item{quiet}{TRUE / FALSE indicating whether to write the POST information to the console}
}
\value{
request_id as a string
}
\description{
Use the Nokia HERE batch geocoding API to geocode lots of addresses in a single call instead of looping over the addresses one by one.
}
\examples{
addresses <- chicago_landmarks[,"Address"]
addresses <- paste(addresses, "chicago IL")
addresses_df <- data.frame(id=1:length(addresses), addresses=addresses)
address_str <- df_to_string(addresses_df)
\donttest{
request_id <- geocodeHERE_batch_upload(address_string = address_str,
                                       email_address = "youremail<at>domain.com")
geocodeHERE_batch_status(request_id)
geocode_data <- geocodeHERE_batch_get_data(request_id)
addresses_df <- merge(addresses_df, geocode_data, by.x="id", by.y="recId", all.x=T)
}
}
\keyword{batch}
\keyword{geocode}

