% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{calcUncertaintyIndex}
\alias{calcUncertaintyIndex}
\title{Diversity index}
\usage{
calcUncertaintyIndex(belongmatrix)
}
\arguments{
\item{belongmatrix}{A membership matrix}
}
\value{
A vector with the values of the diversity (entropy) index
}
\description{
Calculate the diversity (or entropy) index.
}
\details{
The diversity (or entropy) index \insertCite{theil1972statistical}{geocmeans}
is calculated for each observation an varies between 0 and 1. When the value
is close to 0, the observation belong to only one cluster (as in hard
clustering). When the value is close to 1, the observation is undecided and
tends to belong to each cluster. Values above 0.9 should be investigated. The
formula is:

\deqn{H2_{i} = \frac{-\sum[u_{ij}\ln(u_{ij})]}{\ln(k)}}

with \emph{i} and observation, \emph{j} a cluster, \emph{k} the number of clusters and
\emph{u} the membership matrix.

It is a simplified formula because the sum of each row of a membership matrix
is 1.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcUncertaintyIndex(result$Belongings)
}
\references{
\insertAllCited{}
}
