% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{violinPlots}
\alias{violinPlots}
\title{Violin plots}
\usage{
violinPlots(data, groups)
}
\arguments{
\item{data}{A dataframe with numeric columns}

\item{groups}{A vector indicating the group of each observation}
}
\value{
A list of plots created with ggplot2
}
\description{
Return violin plots to compare the distribution of each variable for each
group.
}
\examples{
\dontrun{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
violinPlots(dataset, result$Groups)
}
}
