% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCMclass.R
\name{predict.FCMres}
\alias{predict.FCMres}
\title{Predict method for FCMres object}
\usage{
\method{predict}{FCMres}(
  object,
  new_data,
  nblistw = NULL,
  window = NULL,
  standardize = TRUE,
  ...
)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a simple membership matrix.}

\item{new_data}{A DataFrame with the new observations}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package. Required if data is a dataframe, see the parameter window
if you use a list of rasters as input.}

\item{window}{If data is a list of rasters, then a window must be specified instead of
a list.w object. It will be used to calculate a focal function on each raster. The
window must be a square numeric matrix with odd dimensions (such 3x3). The values in
the matrix indicate the weight to give to each pixel and the centre of the matrix is
the centre of the focal function.}

\item{standardize}{A boolean to specify if the variable must be centred and
reduced (default = True)}

\item{...}{not used}
}
\value{
A numeric matrix with the membership values for each new observation
}
\description{
Function to predict the membership matrix of a new set of observations
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")

# rescaling all the variables used in the analysis
for (field in AnalysisFields) {
    LyonIris@data[[field]] <- scale(LyonIris@data[[field]])
}

# doing the initial clustering
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SGFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, beta = 0.5, standardize = FALSE)

# using a subset of the original dataframe as "new data"
new_data <- LyonIris[c(1, 27, 36, 44, 73),]
new_dataset <- new_data@data[AnalysisFields]
new_nb <- spdep::poly2nb(new_data,queen=TRUE)
new_Wqueen <- spdep::nb2listw(new_nb,style="W")

# doing the prediction
predictions <- predict(result, new_dataset, new_Wqueen, standardize = FALSE)
}
