% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{adjustSpatialWeights}
\alias{adjustSpatialWeights}
\title{Semantic adjusted spatial weights}
\usage{
adjustSpatialWeights(data, listw, style)
}
\arguments{
\item{data}{A dataframe with numeric columns}

\item{listw}{A nb object from spdep}

\item{style}{A letter indicating the weighting scheme (see spdep doc)}
}
\value{
A listw object (spdep like)
}
\description{
Function to adjust the spatial weights so that they represent semantic
distances between neighbours
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
Wqueen2 <- adjustSpatialWeights(dataset,queen,style="C")
}
