% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skelpnts.R
\name{alik_cutoff}
\alias{alik_cutoff}
\alias{alik_plot}
\title{Approximate log-likelihood calculation}
\usage{
alik_cutoff(likopt, par_vals, likthreshold)

alik_plot(alikobj)
}
\arguments{
\item{likopt}{Output from the function \code{\link{alik_optim}}.}

\item{par_vals}{A named list with some of the components "linkp",
"phi", "omg", "kappa".}

\item{likthreshold}{A threshold value proportion to calculate the
cutoff. The cutoff will be calculated as that proportion
relative to the maximum value of the log-likelihood.}

\item{alikobj}{Output from \code{\link{alik_cutoff}}.}
}
\value{
A list with the log-likelihood approximation and cutoff values.

Draws a plot.
}
\description{
Calculate the likelihood approximation at different parameter
values. This function is useful for choosing the skeleton set.

Plot likelihood approximation.
}
\details{
The input \code{par_vals} is meant to contain vector of parameter
values for each parameter. For each element in \code{par_vals},
the other parameters are set equal to the maximisers given in
\code{likopt} and the approximate likelihood is computed. The
cuttoff is calculated using linear interpolation provided by
\code{\link[stats]{approx}}.

The plot can be used to visualise the Laplace approximation to the
likelihood provided by the function \code{\link{alik_cutoff}}.
}
