% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bfse.R
\name{bfse}
\alias{bfse}
\title{Computation of standard errors for Bayes factors}
\usage{
bfse(pargrid, runs, nbatches, bfsize1 = 0.8, method = c("RL", "MW"),
  reference = 1, transf = FALSE, bmmcse.size = "sqroot")
}
\arguments{
\item{pargrid}{A data frame with components "linkp", "phi", "omg",
"kappa". Each row gives a combination of the parameters to compute
the new standard errors.}

\item{runs}{A list with outputs from the function
\code{\link{mcsglmm}} or \code{\link{mcstrga}}.}

\item{nbatches}{An integer scalar or vector of the same length as
runs indicating the number of batches to create for computing the
variance using the samples of the first stage.}

\item{bfsize1}{A scalar or vector of the same length as
\code{runs} with all integer values or all values in (0, 1]. How
many samples (or what proportion of the sample) to use for
estimating the Bayes factors at the first stage. The remaining
sample will be used for estimating the standard errors in the
second stage. Setting it to 1 will perform only the first stage.}

\item{method}{Which method to use to calculate the Bayes factors:
Reverse logistic or Meng-Wong.}

\item{reference}{Which model goes in the denominator.}

\item{transf}{Whether to use the transformed sample mu for the
computations. Otherwise it uses z.}

\item{bmmcse.size}{Size for computing the batch means Monte-Carlo
variance using the samples of the second stage.}
}
\value{
A list with components
\itemize{
\item \code{pargrid} The inputted pargrid augmented with the computed standard
errors.
\item \code{bfEstimate} The estimates of the Bayes factors
\item \code{bfSigma} The covariance matrix for the Bayes factors
estimates.
}
}
\description{
Compute the standard errors for the Bayes factors estimates.
}
\details{
Uses the batch means method to compute the standard errors for
Bayes factors.
}
\references{
Roy, V., Tan, A. and Flegal, J. (2015). Estimating
standard errors for importance sampling estimators with multiple
Markov chains. Technical report, Iowa State University.
\url{http://lib.dr.iastate.edu/stat_las_preprints/34}
}

