% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geogrid.R
\name{geogrid}
\alias{geogrid}
\title{Plots a grid.}
\usage{
geogrid(lat, lon = 0, col = 1, type = "l", lwd = 0, lty = 0,
  pch = "+", nx = 5)
}
\arguments{
\item{lat,lon}{Latitude and longitude of data ( or x and y coordinates),
negative for southern latitudes and western longitudes.  May be supplied as
two vectors or as a dataframe lat (or x) including vectors \code{lat$lat}
and \code{lat$lon} (\code{x$x} and \code{x$y} if projection = none).}

\item{col}{Color number used, default value is 1 (black).}

\item{type}{"l" means line and "p" points.  Default is "l".}

\item{lwd}{Linewidth.  Default value is the value set when the program was
called.}

\item{lty}{Linetype.  Default value is the value set when the program was
called.}

\item{pch}{Type of symbol at gridpoints default is "+".}

\item{nx}{sets smoothness of curved Lambert parallels}
}
\value{
No values returned.
}
\description{
Plots a grid defined by the vectors lat, lon. The grid is plotted on a graph
initialized by geoplot.  lon gives the meridians plotted and lat the
parallels plotted.
}
\examples{
\dontrun{       geogrid(latgr, longgr)

       codgrd <- list(lat = seq(62, 68, by = 0.1), lon = seq(-28, -10, 0.25))
       geogrid(codgrd)   # a fine grid of Iceland and neighbouring seas
       geoplot(new = T)
}
}
\seealso{
\code{\link{geoplot}}, \code{\link{geolines}},
\code{\link{geopolygon}}, \code{\link{geotext}}, \code{\link{geosymbols}},
\code{\link{geopar}}, \code{\link{geolocator}}, \code{\link{geocontour}}.
}

