% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gensvm.grid.R
\name{print.gensvm.grid}
\alias{print.gensvm.grid}
\title{Print the fitted GenSVMGrid model}
\usage{
\method{print}{gensvm.grid}(x, ...)
}
\arguments{
\item{x}{a \code{gensvm.grid} object to print}

\item{\dots}{further arguments are ignored}
}
\value{
returns the object passed as input
}
\description{
Prints the summary of the fitted GenSVMGrid model
}
\examples{
\donttest{
x <- iris[, -5]
y <- iris[, 5]

# fit a grid search and print the resulting object
grid <- gensvm.grid(x, y)
print(grid)
}

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm.grid}}, \code{\link{predict.gensvm.grid}}, 
\code{\link{plot.gensvm.grid}}, \code{\link{gensvm.grid}}, 
\code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
