% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_sample_size_functions.R
\name{ss.calc.linear}
\alias{ss.calc.linear}
\title{Function to Calculate Sample Size in Linear Models}
\usage{
ss.calc.linear(power = 0.8, MAF = NULL, ES = NULL, R2 = NULL,
  sd_y = NULL, Alpha = 0.05, True.Model = "All",
  Test.Model = "All")
}
\arguments{
\item{power}{Vector of the desired power(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{ES}{Vector of effect sizes (difference in means) to detect. Either ES or R2 must be specified.}

\item{R2}{Vector of R-squared values to detect. Either ES or R2 must be specified.}

\item{sd_y}{Standard deviation of the outcome in the population (ignoring genotype). Either sd_y_x or sd_y must be specified.}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the total number of subjects required for all combinations of the specified parameters
}
\description{
Calculates the necessary sample size to acheive the specified level of power to detect an effect size, ES or R2 value, with type 1 error rate, Alpha
}
\examples{
ss <- ss.calc.linear(power=0.8,MAF=0.1,
    ES=3, R2=NULL, sd_y = 1,Alpha=0.05,
    True.Model='All', Test.Model='All')

}
