% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_scaleBar}
\alias{GC_scaleBar}
\title{Update Scale Bar of a GC Chart Cluster}
\usage{
GC_scaleBar(
  GC_chart,
  show = TRUE,
  cluster = NULL,
  scaleBarLineStyle = list(),
  scaleBarTickStyle = list(),
  labelStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{show}{Logical. Whether to show the scale bar.}

\item{cluster}{Numeric or character vector. Clusters in the GC chart to update.}

\item{scaleBarLineStyle}{List of style options for the scale bar line.}

\item{scaleBarTickStyle}{List of style options for the scale bar ticks.}

\item{labelStyle}{List of style options for the scale bar label.}

\item{...}{Additional arguments for scale bar settings.}
}
\value{
Updated GC chart with new scale bar settings.
}
\description{
Modify the scale bar settings for specified clusters within a GC chart.
}
\examples{
genes_data <- data.frame(
 start = c(1000, 9000, 13000, 17000, 21000),
 end = c(4000, 12000, 16000, 20000, 24000),
 name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
 group = c('A', 'B', 'B', 'A', 'C'),
 cluster = c(1, 1, 2, 2, 2)
)

# Set scale bar for individual clusters
GC_chart(genes_data, cluster ="cluster", group = "group") \%>\%
GC_scaleBar(cluster = 1, title = "1 kb", scaleBarUnit = 1000) \%>\%
GC_scaleBar(cluster = 2, title = "2 kb", scaleBarUnit = 2000)

# Style scale bar
GC_chart(genes_data, cluster ="cluster", group = "group", height = "400px") \%>\%
  GC_scaleBar(
    title = "1kb",
    scaleBarUnit = 1000,
    cluster = NULL,
    x = 0,
    y = 50,
    labelStyle = list(
      labelPosition =  "left",
      fontSize = "10px",
      fontFamily = "sans-serif",
      fill = "red", # Text color
      cursor = "default"
      # Any other CSS style for the label
    ),
    textPadding = -2,
    scaleBarLineStyle = list(
      stroke = "black",
      strokeWidth = 1
      # Any other CSS style for the line
    ),
    scaleBarTickStyle = list(
      stroke = "black",
      strokeWidth = 1
      # Any other CSS style for the tick
    )
  )

}
