% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Panel2Lag.R
\name{Panel2Lag}
\alias{Panel2Lag}
\title{Function to compute a vector of 2 lagged values of a variable from panel data.}
\usage{
Panel2Lag(ID, xj)
}
\arguments{
\item{ID}{{Location of the column having time identities (e.g. the week number)}}

\item{xj}{{Data on variable to be lagged linked to ID}}
}
\value{
Vector containing  2 lagged values of xj.
}
\description{
The panel data have a set of time series for each entity (e.g. country)
arranged such that all time series data for one entity is together. The
data for the second entity should be below the entire data for first entity.
When a variable is lagged twice, special care is needed to insert NA's for
the first two time points (e.g. weeks) for each entity (country).
}
\note{
This function is provided for convenient user modifications.
}
\seealso{
A more general function \code{\link{PanelLag}} has examples.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
