#' European Crime Data
#'
#' This data set refers to crime in European countries during 2008.
#' The sources are World Bank and Eurostat.  The crime statistics refers
#' to homicides. It avoids possible reporting bias from the presence
#' of police officers, because homicide reporting in most countries is
#' standardized.  Typical usage is: \code{data(EuroCrime);attach(EuroCrime)}.
#' The secondary source `quandl.com' was used for collecting these data.
#'
#' The variables included in the dataset are:
#' \itemize{
#' \item\code{Country} {Name of the European country}
#' \item\code{crim} {Per capita crime rate}
#' \item\code{off} {Per capita deployment of police officers}
#' }
#'
#' @name EuroCrime
#' @docType data
NULL
