% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silentPairs.R
\name{silentPairs}
\alias{silentPairs}
\title{Function for kernel causality into 3-column matrix admitting control variables}
\usage{
silentPairs(mtx, ctrl = 0, dig = 6, wt = c(1.2, 1.1, 1.05, 1),
  sumwt = 4)
}
\arguments{
\item{mtx}{{The data matrix with many columns, y the first column is fixed and then 
paired with all other columns, one by one and called x.}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{wt}{{Allows user to choose a vector of four alternative weights for SD1 to SD4.}}

\item{sumwt}{{ Sum of weights can be changed here =4(default).}}
}
\value{
If there are p columns in the input matrix, there are p-1 possible
flipped X, Y pairs leaving the control variables alone.  This function
produces p-1 numbers representing the summary sign `sum' from 
the signs sg1 to sg3 associated with the three criteria:
Cr1, Cr2 and Cr3.  Note that sg1 and sg2 themselves are weithted signs using
weighted sum of signs from four orders of stochastic dominance.
In general, a positive sign for weighted sum reported in the column `sum' means
that the first variable listed as the input to this function is the `kernel cause.' 
This function is a summary of \code{someCPairs} allowing for control variables. 
For example, crime `kernel causes' police officer deployment (not vice versa) is indicated by 
the positive sign of `sum' (=3.175) reported for that example included in this package.
}
\description{
Allowing input matrix of control variables, this function produce a 3 column matrix
summarizing the results where the estimated signs of
stochastic dominance order values (+1, 0, -1) are weighted by \code{wt=c(1.2,1.1, 1.05, 1)} to
compute an overall result for all orders of stochastic dominance by a weighted sum for
the crietria Cr1 and Cr2 and added to the Cr3 estimate as: (+1, 0, -1).
}
\details{
The reason for slightly declining weights on the signs from
SD1 to SD4 is simply that the local mean comparisons 
implicit in SD1 are known to be
more reliable than local variance implicit in SD2, local skewness implicit in
SD3 and local kurtosis implicit in SD4. The source of slightly declining sampling
unreliability of higher moments is the
higher power of the deviations from the mean needed in their computations.
The summary results for all
three criteria are reported in one matrix called \code{outVote}:
}
\note{
The output matrix last column for `mtcars' example
has the sum of the scores by the three criteria
combined. If `sum' is positive, then variable X (mpg) is more likely to have been
engineerd to kernel cause the response variable Y, rather than vice versa.

The European Crime data has all three criteria correctly suggesting that
high crime rate kernel causes the deployment of a large number of police officers.
}
\examples{


\dontrun{
silentPairs(mtcars[,1:3],ctrl=mtcars[4:5]) # mpg paired with others
}

options(np.messages=FALSE)
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10 #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
silentPairs(cbind(x2,y2), cbind(z,w2))


}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\references{
'Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See  \code{\link{bootPairs}}.

See  \code{\link{someCPairs}}, \code{\link{some0Pairs}}
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{correlations}
\keyword{criteria,}
\keyword{generalized}

