% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstar.R
\name{rstar}
\alias{rstar}
\title{Function to compute generalized correlation coefficients r*(x,y).}
\usage{
rstar(x, y)
}
\arguments{
\item{x}{Vector of data on the dependent variable}

\item{y}{Vector of data on the regressor}
}
\value{
Four objects created by this function are:
\item{corxy}{r*x|y or regressing x on y}
\item{coryx}{r*y|x or regressing y on x}
\item{pearson.r }{Pearson's product moment correlation coefficient}
\item{pv}{The p-value for testing the Pearson r}
}
\description{
Uses Vinod (2015) definition of generalized (asymmetric) correlation
coefficients.  It requires kernel regression of x on y obtained by using the `np' package.
It also reports usual Pearson correlation coefficient r and p-value for testing
the null hypothesis that (population r)=0.
}
\note{
This function needs the kern function which in turn needs the np package.
}
\examples{

x=sample(1:30);y=sample(1:30); rstar(x,y)

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D.'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\seealso{
See Also as \code{\link{gmcmtx0}}
}
\keyword{asymmetric}
\keyword{p-values}

