% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmcxy_np.R
\name{gmcxy_np}
\alias{gmcxy_np}
\title{Function to compute generalized correlation coefficients r*(x|y) and r*(y|x).}
\usage{
gmcxy_np(x, y)
}
\arguments{
\item{x}{vector of x data}

\item{y}{vector of y data}
}
\value{
\item{corxy}{r*(x|y)  from regressing x on y, where y is the kernel cause.}
\item{coryx}{r*(y|x) from regressing y on x, where x is the cause.}
}
\description{
This function uses the `np' package and assumes that there are no missing data.
}
\note{
This is provided if the user want to avoid calling \code{kern}.
}
\examples{
\dontrun{
set.seed(34);x=sample(1:10);y=sample(2:11)
gmcxy_np(x,y)}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D.'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
Using R,' Chapter 4 in 'Handbook of Statistics: Computational Statistics
with R,' Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\keyword{R*}
\keyword{asymmetric}
\keyword{kernel}
\keyword{regression,}

